/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.worldgen.WorldGenSurfaceStructureAS;
import com.windanesz.ancientspellcraft.worldgen.WorldGenUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class WorldGenAncientTemple
extends WorldGenSurfaceStructureAS {
    public String getStructureName() {
        return "ancient_temple";
    }

    public long getRandomSeedModifier() {
        return 12342215L;
    }

    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Settings.worldgenSettings.battlemageKeepDimensions, (int)world.field_73011_w.getDimension()) && Settings.worldgenSettings.ancientVaultRarity > 0 && random.nextInt(Settings.worldgenSettings.ancientVaultRarity) == 0;
    }

    public ResourceLocation getStructureFile(Random random) {
        return AncientSpellcraft.settings.ancientTempleFiles[0];
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        EnumDyeColor colour = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        Biome biome = world.func_180494_b(origin);
        IBlockState biomeCover = biome.field_76752_A;
        float mossiness = WorldGenAncientTemple.getBiomeMossiness(biome);
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150325_L ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150325_L.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150404_cg ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150404_cg.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_180394_cL ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150404_cg.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150346_d ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150349_c ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, new WoodTypeTemplateProcessor(woodType), new MossifierTemplateProcessor(mossiness, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150417_aV && w.field_73012_v.nextFloat() < 0.1f ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), i.field_186244_c) : i, (w, p, i) -> {
            TileEntityBookshelf.markAsNatural((NBTTagCompound)i.field_186244_c);
            return i;
        }, (w, p, i) -> {
            TileSageLectern.markAsNatural(i.field_186244_c);
            return i;
        }, (w, p, i) -> i.field_186243_b.func_177230_c() == WizardryBlocks.receptacle ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b, this.setElement(i.field_186244_c, element)) : i});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        ASAntiqueAtlasIntegration.markMysteryStructure(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            WorldGenUtils.spawnEntityByType(world, (String)entry.getValue(), ItemWizardArmour.ArmourClass.BATTLEMAGE, origin, vec, blocksPlaced, Element.MAGIC, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player.field_70173_aa % 20 == 0) {
            WizardryAdvancementTriggers.visit_structure.trigger((EntityPlayerMP)event.player);
        }
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }

    NBTTagCompound setElement(NBTTagCompound compound, Element element) {
        compound.func_74768_a("Element", element.ordinal());
        return compound;
    }
}

