/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.google.common.collect.ImmutableMap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.worldgen.WorldGenSurfaceStructureAS;
import com.windanesz.ancientspellcraft.worldgen.WorldGenUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import electroblob.wizardry.worldgen.WoodTypeTemplateProcessor;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber
public class WorldGenBattlemageKeep
extends WorldGenSurfaceStructureAS {
    private static final String WIZARD_DATA_BLOCK_TAG = "wizard";
    private static final String EVIL_WIZARD_DATA_BLOCK_TAG = "evil_wizard";
    private static final String HORSE_DATA_BLOCK_TAG = "horse";
    private final Map<BiomeDictionary.Type, IBlockState> specialWallBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180395_cM.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150417_aV.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150385_bj.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150322_A.func_176223_P());
    private final Map<BiomeDictionary.Type, IBlockState> specialStairBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_150372_bz.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150390_bg.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150387_bl.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150372_bz.func_176223_P());
    private final Map<BiomeDictionary.Type, IBlockState> specialSlabBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180389_cP.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150333_U.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.NETHERBRICK), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND));

    public String getStructureName() {
        return "battlemage_camp";
    }

    public long getRandomSeedModifier() {
        return 12489238L;
    }

    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Settings.worldgenSettings.battlemageKeepDimensions, (int)world.field_73011_w.getDimension()) && Settings.worldgenSettings.battlemageKeepRarity > 0 && random.nextInt(Settings.worldgenSettings.battlemageKeepRarity) == 0;
    }

    public ResourceLocation getStructureFile(Random random) {
        return AncientSpellcraft.settings.battlemageKeepFiles[random.nextInt(AncientSpellcraft.settings.battlemageKeepFiles.length)];
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        EnumDyeColor colour = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        Biome biome = world.func_180494_b(origin);
        IBlockState biomeCover = biome.field_76752_A;
        float mossiness = WorldGenBattlemageKeep.getBiomeMossiness(biome);
        IBlockState wallMaterial = this.specialWallBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialWallBlocks::get).orElse(Blocks.field_150347_e.func_176223_P());
        IBlockState stairMaterial = this.specialStairBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialStairBlocks::get).orElse(Blocks.field_150446_ar.func_176223_P());
        IBlockState slabMaterial = this.specialSlabBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialSlabBlocks::get).orElse(Blocks.field_150333_U.func_176223_P());
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150325_L ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150325_L.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150404_cg ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150404_cg.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_180394_cL ? new Template.BlockInfo(i.field_186242_a, Blocks.field_150404_cg.func_176203_a(colour.func_176765_a()), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150347_e ? new Template.BlockInfo(i.field_186242_a, wallMaterial, i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150446_ar ? new Template.BlockInfo(i.field_186242_a, stairMaterial.func_177226_a((IProperty)BlockStairs.field_176309_a, i.field_186243_b.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_177226_a((IProperty)BlockStairs.field_176308_b, i.field_186243_b.func_177229_b((IProperty)BlockStairs.field_176308_b)).func_177226_a((IProperty)BlockStairs.field_176310_M, i.field_186243_b.func_177229_b((IProperty)BlockStairs.field_176310_M)), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150333_U ? new Template.BlockInfo(i.field_186242_a, slabMaterial, i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150346_d || i.field_186243_b.func_177230_c() == Blocks.field_150349_c ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, new WoodTypeTemplateProcessor(woodType), new MossifierTemplateProcessor(mossiness, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> {
            if (i.field_186243_b.func_177230_c() != Blocks.field_150350_a) {
                blocksPlaced.add(p);
            }
            return i;
        }});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        if (settings.func_186213_g() != null) {
            float edgeBlendFactor = 0.3f;
            for (BlockPos currPos : BlockPos.func_191532_a((int)settings.func_186213_g().field_78897_a, (int)(settings.func_186213_g().field_78895_b - 8), (int)settings.func_186213_g().field_78896_c, (int)settings.func_186213_g().field_78893_d, (int)settings.func_186213_g().field_78895_b, (int)settings.func_186213_g().field_78892_f)) {
                if (currPos.func_177956_o() == settings.func_186213_g().field_78895_b && world.func_175708_f(currPos, true) && world.func_175623_d(currPos)) {
                    world.func_180501_a(currPos, Blocks.field_150431_aC.func_176223_P(), 2);
                    continue;
                }
                if (currPos.func_177956_o() == settings.func_186213_g().field_78895_b && !(world.field_73012_v.nextFloat() < edgeBlendFactor) || !(world.func_180495_p(currPos).func_177230_c() instanceof BlockTallGrass) && !world.func_175623_d(currPos) && !(world.func_180495_p(currPos).func_177230_c() instanceof BlockBush) && !(world.func_180495_p(currPos).func_177230_c() instanceof BlockLog)) continue;
                IBlockState blockState = currPos.func_177956_o() == settings.func_186213_g().field_78895_b ? biome.field_76752_A : biome.field_76753_B;
                world.func_175656_a(currPos, blockState);
            }
        }
        ASAntiqueAtlasIntegration.markBattlemageKeep(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            WorldGenUtils.spawnEntityByType(world, (String)entry.getValue(), ItemWizardArmour.ArmourClass.BATTLEMAGE, origin, vec, blocksPlaced, Element.MAGIC, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player.field_70173_aa % 20 == 0) {
            WizardryAdvancementTriggers.visit_structure.trigger((EntityPlayerMP)event.player);
        }
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }

    @Override
    protected void postGenerate(Random random, World world, PlacementSettings settings) {
    }
}

