/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.windanesz.ancientspellcraft.entity.living.EntityClassWizard;
import com.windanesz.ancientspellcraft.entity.living.EntityEvilClassWizard;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMage;
import com.windanesz.ancientspellcraft.entity.living.EntityStoneGuardian;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.Spells;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WorldGenUtils {
    private static final String WIZARD_DATA_BLOCK_TAG = "wizard";
    private static final String EVIL_WIZARD_DATA_BLOCK_TAG = "evil_wizard";
    private static final String HORSE_DATA_BLOCK_TAG = "horse";
    private static final String STONE_GUARDIAN = "stone_guardian";
    private static final String SKELETON_MAGE_DATA_BLOCK_TAG = "skeleton_mage";
    private static final String SKELETON_MAGE_GHOST_DATA_BLOCK_TAG = "skeleton_mage_ghost";
    private static final String EVIL_WARLOCK_TAG = "warlock";

    public static void spawnEntityByType(World world, String entityType, ItemWizardArmour.ArmourClass armourClass, BlockPos origin, Vec3d vec, Set<BlockPos> towerBlocks, Element element, boolean isSkeletonGhost) {
        switch (entityType) {
            case "wizard": 
            case "warlock": {
                WorldGenUtils.spawnClassWizard(world, armourClass, origin, vec, towerBlocks);
                break;
            }
            case "evil_wizard": {
                WorldGenUtils.spawnEvilClassWizard(world, armourClass, origin, vec);
                break;
            }
            case "horse": {
                WorldGenUtils.spawnHorse(world, vec);
                break;
            }
            case "stone_guardian": {
                WorldGenUtils.spawnGuardian(world, origin, vec);
                break;
            }
            case "skeleton_mage": 
            case "skeleton_mage_ghost": {
                WorldGenUtils.spawnSkeletonMage(world, origin, vec, element, isSkeletonGhost);
                break;
            }
            default: {
                Wizardry.logger.info("Unrecognised data block value {} in structure", (Object)entityType);
            }
        }
    }

    public static void spawnClassWizard(World world, ItemWizardArmour.ArmourClass armourClass, BlockPos origin, Vec3d vec, Set<BlockPos> towerBlocks) {
        EntityClassWizard wizard = new EntityClassWizard(world);
        wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
        wizard.setArmourClass(armourClass);
        wizard.func_180482_a(world.func_175649_E(origin), null);
        wizard.setTowerBlocks(towerBlocks);
        world.func_72838_d((Entity)wizard);
    }

    public static void spawnEvilClassWizard(World world, ItemWizardArmour.ArmourClass armourClass, BlockPos origin, Vec3d vec) {
        EntityEvilClassWizard wizard = new EntityEvilClassWizard(world);
        wizard.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
        wizard.hasStructure = true;
        wizard.setArmourClass(armourClass);
        wizard.func_180482_a(world.func_175649_E(origin), null);
        world.func_72838_d((Entity)wizard);
    }

    public static void spawnHorse(World world, Vec3d vec) {
        EntityHorse horse = new EntityHorse(world);
        horse.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
        world.func_72838_d((Entity)horse);
    }

    public static void spawnGuardian(World world, BlockPos origin, Vec3d vec) {
        EntityStoneGuardian guardian = new EntityStoneGuardian(world);
        guardian.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
        guardian.func_180482_a(world.func_175649_E(origin), null);
        guardian.setSeal(Optional.of(new BlockPos(vec.field_72450_a, vec.field_72448_b - 1.0, vec.field_72449_c)));
        guardian.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 40));
        world.func_72838_d((Entity)guardian);
    }

    public static void spawnSkeletonMage(World world, BlockPos origin, Vec3d vec, Element element, boolean ghost) {
        EntitySkeletonMage skeleton = new EntitySkeletonMage(world);
        skeleton.setElement(element);
        skeleton.setRare(true);
        skeleton.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0f, 0.0f);
        skeleton.func_180482_a(world.func_175649_E(origin), null);
        if (element == Element.HEALING) {
            skeleton.populateSpellList(Element.HEALING, Spells.ray_of_purification);
        }
        world.func_72838_d((Entity)skeleton);
    }
}

