/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.worldgen.WorldGenUtils;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenWarlockStructure
extends WorldGenSurfaceStructure {
    public String getStructureName() {
        return "warlock_structure";
    }

    public long getRandomSeedModifier() {
        return 27675449L;
    }

    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Settings.worldgenSettings.warlockStructureDimensions, (int)world.field_73011_w.getDimension()) && Settings.worldgenSettings.warlockStructureRarity > 0 && random.nextInt(Settings.worldgenSettings.warlockStructureRarity) == 0;
    }

    public ResourceLocation getStructureFile(Random random) {
        return new ResourceLocation("ancientspellcraft", "warlock_rite_0");
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        ITemplateProcessor processor = (w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockRunestone ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockRunestone.ELEMENT, (Comparable)element), i.field_186244_c) : i;
        template.func_189960_a(world, origin, processor, settings, 18);
        ASAntiqueAtlasIntegration.markMysteryStructure(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            WorldGenUtils.spawnEntityByType(world, (String)entry.getValue(), ItemWizardArmour.ArmourClass.WARLOCK, origin, vec, blocksPlaced, Element.MAGIC, false);
        }
    }
}

