/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.worldgen.WorldGenSurfaceStructure;
import com.windanesz.ancientspellcraft.worldgen.WorldGenUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class WorldgenFallenTower
extends WorldGenSurfaceStructure {
    private static final List<BiomeDictionary.Type> BIOME_TYPES = ImmutableList.of((Object)BiomeDictionary.Type.FOREST);
    private final Map<BiomeDictionary.Type, IBlockState> specialWallBlocks = ImmutableMap.of((Object)BiomeDictionary.Type.MESA, (Object)Blocks.field_180395_cM.func_176223_P(), (Object)BiomeDictionary.Type.MOUNTAIN, (Object)Blocks.field_150417_aV.func_176223_P(), (Object)BiomeDictionary.Type.NETHER, (Object)Blocks.field_150385_bj.func_176223_P(), (Object)BiomeDictionary.Type.SANDY, (Object)Blocks.field_150322_A.func_176223_P());

    public String getStructureName() {
        return "fallen_tower";
    }

    public long getRandomSeedModifier() {
        return 13428681L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        if (!ArrayUtils.contains((int[])Settings.worldgenSettings.ancientVaultDimensions, (int)world.field_73011_w.getDimension())) return false;
        if (Settings.worldgenSettings.fallenTowerRarity <= 0) return false;
        if (random.nextInt(Settings.worldgenSettings.fallenTowerRarity) != 0) return false;
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(new BlockPos(chunkX * 16 + 16, 0, chunkZ * 16 + 16))).stream().anyMatch(BIOME_TYPES::contains)) return false;
        return true;
    }

    public ResourceLocation getStructureFile(Random random) {
        return AncientSpellcraft.settings.fallenTowerFiles[0];
    }

    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        EnumDyeColor colour = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        Biome biome = world.func_180494_b(origin);
        IBlockState biomeCover = biome.field_76752_A;
        float mossiness = WorldgenFallenTower.getBiomeMossiness(biome);
        IBlockState wallMaterial = this.specialWallBlocks.keySet().stream().filter(t -> BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)t)).findFirst().map(this.specialWallBlocks::get).orElse(Blocks.field_150347_e.func_176223_P());
        BlockPlanks.EnumType woodType = BlockUtils.getBiomeWoodVariant((Biome)biome);
        HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
        MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockStainedHardenedClay ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)colour), i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150346_d ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, new MossifierTemplateProcessor(mossiness, 0.04f, origin.func_177956_o() + 1), (w, p, i) -> i.field_186243_b.func_177230_c() == Blocks.field_150349_c ? new Template.BlockInfo(i.field_186242_a, biomeCover, i.field_186244_c) : i, (w, p, i) -> i.field_186243_b.func_177230_c() == WizardryBlocks.receptacle ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b, this.setElement(i.field_186244_c, element)) : i, (w, p, i) -> {
            TileEntityBookshelf.markAsNatural((NBTTagCompound)i.field_186244_c);
            return i;
        }, (w, p, i) -> {
            TileSageLectern.markAsNatural(i.field_186244_c);
            return i;
        }});
        template.func_189960_a(world, origin, (ITemplateProcessor)processor, settings, 18);
        if (settings.func_186213_g() != null) {
            float edgeBlendFactor = 0.3f;
            for (BlockPos currPos : BlockPos.func_191532_a((int)settings.func_186213_g().field_78897_a, (int)settings.func_186213_g().field_78894_e, (int)settings.func_186213_g().field_78896_c, (int)settings.func_186213_g().field_78893_d, (int)(settings.func_186213_g().field_78894_e + 8), (int)settings.func_186213_g().field_78892_f)) {
                if (currPos.func_177956_o() == settings.func_186213_g().field_78895_b && !(world.field_73012_v.nextFloat() < edgeBlendFactor) || world.func_175623_d(currPos)) continue;
                world.func_175698_g(currPos);
            }
        }
        ASAntiqueAtlasIntegration.markMysteryStructure(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            Vec3d vec = GeometryUtils.getCentre((BlockPos)((BlockPos)entry.getKey()));
            WorldGenUtils.spawnEntityByType(world, (String)entry.getValue(), ItemWizardArmour.ArmourClass.BATTLEMAGE, origin, vec, blocksPlaced, Element.values()[1 + random.nextInt(Element.values().length - 1)], true);
        }
    }

    NBTTagCompound setElement(NBTTagCompound compound, Element element) {
        compound.func_74768_a("Element", element.ordinal());
        return compound;
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }

    @Override
    protected void postGenerate(Random random, World world, PlacementSettings settings) {
    }
}

