/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.client.render;

import com.favouritedraogn.arcane_essentials.joml.Matrix4f;
import com.favouritedraogn.arcane_essentials.joml.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderUtils {
    public static void drawQuad(int normal, Vector4f pos1, Vector4f pos2, Vector4f pos3, Vector4f pos4, double u1, double v1, double u2, double v2) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        if (normal == 0 || normal == 2) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_187315_a(u2, v1).func_181675_d();
            vb.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_187315_a(u2, v2).func_181675_d();
            vb.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_187315_a(u1, v2).func_181675_d();
            vb.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_187315_a(u1, v1).func_181675_d();
            t.func_78381_a();
        }
        if (normal == 1 || normal == 2) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)pos1.x, (double)pos1.y, (double)pos1.z).func_187315_a(u2, v1).func_181675_d();
            vb.func_181662_b((double)pos4.x, (double)pos4.y, (double)pos4.z).func_187315_a(u1, v1).func_181675_d();
            vb.func_181662_b((double)pos3.x, (double)pos3.y, (double)pos3.z).func_187315_a(u1, v2).func_181675_d();
            vb.func_181662_b((double)pos2.x, (double)pos2.y, (double)pos2.z).func_187315_a(u2, v2).func_181675_d();
            t.func_78381_a();
        }
    }

    public static void renderCube(float x, float y, float z, double u1, double u2, double v1, double v2, float size, float rotateX, float rotateY, float rotateZ) {
        Matrix4f mat = new Matrix4f();
        mat.translate(x, y + 0.4f, z);
        mat.rotate(rotateX, 1.0f, 0.0f, 0.0f);
        mat.rotate(rotateY, 0.0f, 1.0f, 0.0f);
        mat.rotate(rotateZ, 0.0f, 0.0f, 1.0f);
        Vector4f lbf = new Vector4f(-0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rbf = new Vector4f(0.5f * size, -0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f ltf = new Vector4f(-0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f rtf = new Vector4f(0.5f * size, 0.5f * size, -0.5f * size, 1.0f).mul(mat);
        Vector4f lbb = new Vector4f(-0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rbb = new Vector4f(0.5f * size, -0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f ltb = new Vector4f(-0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        Vector4f rtb = new Vector4f(0.5f * size, 0.5f * size, 0.5f * size, 1.0f).mul(mat);
        RenderUtils.drawQuad(2, ltb, lbb, lbf, ltf, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtb, rbb, rbf, rtf, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rbb, rbf, lbf, lbb, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtb, rtf, ltf, ltb, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtf, rbf, lbf, ltf, u1, v1, u2, v2);
        RenderUtils.drawQuad(2, rtb, rbb, lbb, ltb, u1, v1, u2, v2);
    }

    public static void drawSphere(float radius, float latStep, float longStep, boolean inside, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        boolean goingUp = inside;
        buffer.func_181662_b(0.0, goingUp ? (double)(-radius) : (double)radius, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        for (float longitude = (float)(-Math.PI); longitude <= (float)Math.PI; longitude += longStep) {
            for (float theta = 1.5707964f - latStep; theta >= -1.5707964f + latStep; theta -= latStep) {
                float latitude = goingUp ? -theta : theta;
                float hRadius = radius * MathHelper.func_76134_b((float)latitude);
                float vy = radius * MathHelper.func_76126_a((float)latitude);
                float vx = hRadius * MathHelper.func_76126_a((float)longitude);
                float vz = hRadius * MathHelper.func_76134_b((float)longitude);
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
                vx = hRadius * MathHelper.func_76126_a((float)(longitude + longStep));
                vz = hRadius * MathHelper.func_76134_b((float)(longitude + longStep));
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
            }
            buffer.func_181662_b(0.0, goingUp ? (double)radius : (double)(-radius), 0.0).func_181666_a(r, g, b, a).func_181675_d();
            goingUp = !goingUp;
        }
        tessellator.func_78381_a();
    }

    public static void drawSphere(float radius, float latStep, float longStep, boolean inside, float r, float g, float b, float a, @Nonnull ResourceLocation texture) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        boolean goingUp = inside;
        buffer.func_181662_b(0.0, goingUp ? (double)(-radius) : (double)radius, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        for (float longitude = (float)(-Math.PI); longitude <= (float)Math.PI; longitude += longStep) {
            for (float theta = 1.5707964f - latStep; theta >= -1.5707964f + latStep; theta -= latStep) {
                float latitude = goingUp ? -theta : theta;
                float hRadius = radius * MathHelper.func_76134_b((float)latitude);
                float vy = radius * MathHelper.func_76126_a((float)latitude);
                float vx = hRadius * MathHelper.func_76126_a((float)longitude);
                float vz = hRadius * MathHelper.func_76134_b((float)longitude);
                float u = longitude / ((float)Math.PI * 2) + 0.5f;
                float v = 0.5f - latitude / (float)Math.PI;
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_187315_a((double)u, (double)v).func_181666_a(r, g, b, a).func_181675_d();
                vx = hRadius * MathHelper.func_76126_a((float)(longitude + longStep));
                vz = hRadius * MathHelper.func_76134_b((float)(longitude + longStep));
                float u1 = (longitude + longStep) / ((float)Math.PI * 2) + 0.5f;
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_187315_a((double)u1, (double)v).func_181666_a(r, g, b, a).func_181675_d();
            }
            float u = longitude / ((float)Math.PI * 2) + 0.5f;
            buffer.func_181662_b(0.0, goingUp ? (double)radius : (double)(-radius), 0.0).func_187315_a((double)u, goingUp ? 0.0 : 1.0).func_181666_a(r, g, b, a).func_181675_d();
            goingUp = !goingUp;
        }
        tessellator.func_78381_a();
    }
}

