/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.client.render;

import com.favouritedragon.arcaneessentials.client.render.RenderUtils;
import com.favouritedragon.arcaneessentials.common.entity.EntityWaterBall;
import com.favouritedraogn.arcane_essentials.joml.Matrix4f;
import com.favouritedraogn.arcane_essentials.joml.Vector4f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderWaterBall
extends Render<EntityWaterBall> {
    private static final ResourceLocation water = new ResourceLocation("minecraft", "textures/blocks/water_still.png");

    public RenderWaterBall(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntityWaterBall ball, double x, double y, double z, float entityYaw, float partialTicks) {
        float ticks = (float)ball.field_70173_aa + partialTicks;
        float colorEnhancement = 1.2f;
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(water);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)colorEnhancement, (float)colorEnhancement, (float)colorEnhancement, (float)0.6f);
        Matrix4f mat = new Matrix4f();
        mat.translate((float)x - ball.getSize() / 2.0f, (float)y, (float)z - ball.getSize() / 2.0f);
        Vector4f lbf = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul(mat);
        Vector4f rbf = new Vector4f(ball.getSize(), 0.0f, 0.0f, 1.0f).mul(mat);
        Vector4f ltf = new Vector4f(0.0f, ball.getSize(), 0.0f, 1.0f).mul(mat);
        Vector4f rtf = new Vector4f(ball.getSize(), ball.getSize(), 0.0f, 1.0f).mul(mat);
        Vector4f lbb = new Vector4f(0.0f, 0.0f, ball.getSize(), 1.0f).mul(mat);
        Vector4f rbb = new Vector4f(ball.getSize(), 0.0f, ball.getSize(), 1.0f).mul(mat);
        Vector4f ltb = new Vector4f(0.0f, ball.getSize(), ball.getSize(), 1.0f).mul(mat);
        Vector4f rtb = new Vector4f(ball.getSize(), ball.getSize(), ball.getSize(), 1.0f).mul(mat);
        float t1 = ticks * (float)Math.PI / 10.0f;
        float t2 = t1 + 1.5707964f;
        float amt = 0.05f;
        lbf.add(MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76134_b((float)t2) * amt, 0.0f);
        rbf.add(MathHelper.func_76126_a((float)t1) * amt, MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76126_a((float)t2) * amt, 0.0f);
        lbb.add(MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76134_b((float)t2) * amt, 0.0f);
        rbb.add(MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76134_b((float)t1) * amt, 0.0f);
        ltf.add(MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76126_a((float)t1) * amt, 0.0f);
        rtf.add(MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76126_a((float)t1) * amt, MathHelper.func_76134_b((float)t1) * amt, 0.0f);
        ltb.add(MathHelper.func_76126_a((float)t1) * amt, MathHelper.func_76126_a((float)t2) * amt, MathHelper.func_76134_b((float)t1) * amt, 0.0f);
        rtb.add(MathHelper.func_76134_b((float)t1) * amt, MathHelper.func_76134_b((float)t2) * amt, MathHelper.func_76126_a((float)t1) * amt, 0.0f);
        float existed = ticks / 4.0f;
        int anim = (int)existed % 16;
        float v1 = (float)anim / 16.0f;
        float v2 = v1 + 0.0625f;
        RenderUtils.drawQuad(2, ltb, lbb, lbf, ltf, 0.0, v1, 1.0, v2);
        RenderUtils.drawQuad(2, rtb, rbb, rbf, rtf, 0.0, v1, 1.0, v2);
        RenderUtils.drawQuad(2, rbb, rbf, lbf, lbb, 0.0, v1, 1.0, v2);
        RenderUtils.drawQuad(2, rtb, rtf, ltf, ltb, 0.0, v1, 1.0, v2);
        RenderUtils.drawQuad(2, rtf, rbf, lbf, ltf, 0.0, v1, 1.0, v2);
        RenderUtils.drawQuad(2, rtb, rbb, lbb, ltb, 0.0, v1, 1.0, v2);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    private static void drawSphere(float radius, float latStep, float longStep, boolean inside, float r, float g, float b, float a, @Nullable ResourceLocation texture) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        boolean goingUp = inside;
        buffer.func_181662_b(0.0, goingUp ? (double)(-radius) : (double)radius, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        for (float longitude = (float)(-Math.PI); longitude <= (float)Math.PI; longitude += longStep) {
            for (float theta = 1.5707964f - latStep; theta >= -1.5707964f + latStep; theta -= latStep) {
                float latitude = goingUp ? -theta : theta;
                float hRadius = radius * MathHelper.func_76134_b((float)latitude);
                float vy = radius * MathHelper.func_76126_a((float)latitude);
                float vx = hRadius * MathHelper.func_76126_a((float)longitude);
                float vz = hRadius * MathHelper.func_76134_b((float)longitude);
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
                vx = hRadius * MathHelper.func_76126_a((float)(longitude + longStep));
                vz = hRadius * MathHelper.func_76134_b((float)(longitude + longStep));
                if (texture != null) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
                }
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
            }
            buffer.func_181662_b(0.0, goingUp ? (double)radius : (double)(-radius), 0.0).func_181666_a(r, g, b, a).func_181675_d();
            goingUp = !goingUp;
        }
        tessellator.func_78381_a();
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityWaterBall entity) {
        return null;
    }
}

