/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.entity;

import com.favouritedragon.arcaneessentials.common.entity.EntityMagicConstruct;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import com.favouritedragon.arcaneessentials.common.util.DamageSources;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityCycloneShield
extends EntityMagicConstruct {
    private static final DataParameter<Float> SYNC_RADIUS = EntityDataManager.func_187226_a(EntityCycloneShield.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityCycloneShield(World par1World) {
        super(par1World);
    }

    public EntityCycloneShield(World world, double x, double y, double z, EntityLivingBase caster, int lifetime, float damageMultiplier, float radius) {
        super(world);
        this.setOwner((Entity)caster);
        this.func_70107_b(x, y, z);
        this.setCaster(caster);
        this.lifetime = lifetime;
        this.damageMultiplier = damageMultiplier;
        this.setRadius(radius);
    }

    private void Dissipate() {
        if (!this.field_70170_p.field_72995_K && this.getCaster() != null) {
            double x = this.field_70165_t;
            double y = this.field_70163_u + (double)this.getCaster().func_70047_e();
            double z = this.field_70161_v;
            List targets = EntityUtils.getEntitiesWithinRadius((double)(this.getRadius() * 1.25f), (double)x, (double)y, (double)z, (World)this.field_70170_p, EntityLivingBase.class);
            for (EntityLivingBase target : targets) {
                if (!this.isValidTarget((Entity)target)) continue;
                target.func_70024_g(target.field_70165_t - x, target.field_70163_u - y + 0.1, target.field_70161_v - z);
                if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)DamageSources.PRESSURE, (Entity)target)) {
                    target.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.getCaster(), (MagicDamage.DamageType)DamageSources.PRESSURE), 4.0f * this.damageMultiplier);
                }
                target.func_184224_h(false);
                ArcaneUtils.applyPlayerKnockback((Entity)target);
            }
            AxisAlignedBB box = new AxisAlignedBB(x + (double)(this.getRadius() * 1.5f), y + (double)(this.getRadius() * 1.5f), z + (double)(this.getRadius() * 1.5f), x - (double)(this.getRadius() * 1.5f), y - (double)(this.getRadius() * 1.5f), z - (double)(this.getRadius() * 1.5f));
            List projectiles = this.field_70170_p.func_72872_a(Entity.class, box);
            for (Entity projectile : projectiles) {
                if ((!projectile.func_70067_L() || !projectile.func_70104_M()) && !(projectile instanceof EntityArrow) && !(projectile instanceof EntityThrowable) || projectile instanceof EntityLivingBase) continue;
                projectile.field_70159_w = projectile.field_70165_t - x;
                projectile.field_70181_x = projectile.field_70163_u - y;
                projectile.field_70179_y = projectile.field_70161_v - z;
            }
        }
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.field_70180_af.func_187227_b(SYNC_RADIUS, (Object)Float.valueOf(radius));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_RADIUS, (Object)Float.valueOf(1.0f));
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getCaster() != null) {
            double x = this.field_70165_t;
            double y = this.field_70163_u + (double)this.getCaster().func_70047_e();
            double z = this.field_70161_v;
            List targets = EntityUtils.getEntitiesWithinRadius((double)this.getRadius(), (double)x, (double)y, (double)z, (World)this.field_70170_p, EntityLivingBase.class);
            for (EntityLivingBase target : targets) {
                if (target == this.getCaster() || !this.isValidTarget((Entity)target)) continue;
                boolean b = this.field_70170_p.field_73012_v.nextBoolean();
                double multiplier = ((double)this.getRadius() - target.func_70011_f(x, y, z)) * 0.0025;
                if (b) {
                    target.func_70024_g((target.field_70165_t - x) * multiplier, (target.field_70163_u - y) * multiplier, (target.field_70161_v - z) * multiplier);
                } else {
                    target.func_70024_g((x - target.field_70165_t) * multiplier, (target.field_70163_u - y) * multiplier, (z - target.field_70161_v) * multiplier);
                }
                if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)DamageSources.PRESSURE, (Entity)target)) {
                    target.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.getCaster(), (MagicDamage.DamageType)DamageSources.PRESSURE), 0.5f * this.damageMultiplier);
                }
                target.func_184224_h(false);
                ArcaneUtils.applyPlayerKnockback((Entity)target);
            }
            AxisAlignedBB box = new AxisAlignedBB(x + (double)(this.getRadius() * 1.25f), y + (double)(this.getRadius() * 1.25f), z + (double)(this.getRadius() * 1.25f), x - (double)(this.getRadius() * 1.25f), y - (double)(this.getRadius() * 1.25f), z - (double)(this.getRadius() * 1.25f));
            List projectiles = this.field_70170_p.func_72872_a(Entity.class, box);
            for (Entity projectile : projectiles) {
                if ((!projectile.func_70067_L() || !projectile.func_70104_M()) && !(projectile instanceof EntityArrow) && !(projectile instanceof EntityThrowable) || projectile instanceof EntityLivingBase) continue;
                double multiplier = ((double)this.getRadius() - projectile.func_70011_f(x, y, z)) * 0.0025;
                projectile.field_70159_w = (projectile.field_70165_t - x) * multiplier;
                projectile.field_70181_x = (projectile.field_70163_u - y) * multiplier;
                projectile.field_70179_y = (projectile.field_70161_v - z) * multiplier;
            }
        }
        if (this.field_70173_aa % 4 == 0 && this.getCaster() != null) {
            this.field_70170_p.func_184134_a(this.getCaster().field_70165_t, this.getCaster().field_70163_u, this.getCaster().field_70161_v, WizardrySounds.ENTITY_BLIZZARD_AMBIENT, SoundCategory.PLAYERS, 0.5f + this.field_70170_p.field_73012_v.nextFloat() / 20.0f, 2.0f + this.field_70170_p.field_73012_v.nextFloat() / 20.0f, true);
        }
    }

    public void func_70106_y() {
        this.Dissipate();
        super.func_70106_y();
    }
}

