/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.entity;

import com.favouritedragon.arcaneessentials.common.entity.EntityFlamePillar;
import com.favouritedragon.arcaneessentials.common.entity.EntityMagicBolt;
import com.favouritedragon.arcaneessentials.common.spell.fire.KaFrizzle;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFireball
extends EntityMagicBolt {
    private float damage;
    private int lifetime = 40;
    private int burnDuration;

    public EntityFireball(World world) {
        super(world);
    }

    public void setBurnDuration(int duration) {
        this.burnDuration = duration;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public MagicDamage.DamageType getDamageType() {
        return MagicDamage.DamageType.FIRE;
    }

    @Override
    public boolean doDeceleration() {
        return false;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    private void Explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 1.0f + this.field_70170_p.field_73012_v.nextFloat() / 10.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() / 10.0f);
            List hit = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_186662_g((double)(this.getSize() / 4.0f)));
            if (!hit.isEmpty()) {
                for (Entity target : hit) {
                    if (target == this || target == this.getCaster() || !target.func_70067_L()) continue;
                    target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)this.getCaster(), (MagicDamage.DamageType)this.getDamageType()), (float)this.getDamage() * 0.2f);
                    target.func_70024_g(this.field_70159_w / 4.0, this.field_70181_x / 4.0, this.field_70179_y / 4.0);
                    target.func_70015_d(this.burnDuration);
                    ArcaneUtils.applyPlayerKnockback(target);
                }
            }
        }
        if (this.getBehaviour() instanceof KaFrizzle.KaFrizzleBehaviour) {
            EntityFlamePillar pillar = new EntityFlamePillar(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getCaster(), (int)this.getSize() * 30, (float)this.getDamage() / 6.0f, this.getSize() / 2.0f, this.getSize() * 5.0f, 120 + (int)(this.getSize() * 5.0f));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)pillar);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            int i = 0;
            while ((float)i < 50.0f - this.getSize()) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(this.func_174791_d()).time(10).vel(this.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)this.getSize(), this.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)this.getSize(), this.field_70170_p.field_73012_v.nextGaussian() / 10.0 * (double)this.getSize()).scale(0.75f + this.getSize() / 2.0f + this.field_70170_p.field_73012_v.nextFloat()).spawn(this.field_70170_p);
                ++i;
            }
        }
        this.field_70128_L = true;
    }

    @Override
    protected void tickInGround() {
        this.func_70106_y();
    }

    @Override
    public void func_70106_y() {
        this.Explode();
        super.func_70106_y();
    }

    @Override
    protected void onEntityHit(EntityLivingBase entityHit) {
        super.onEntityHit(entityHit);
        if (this.canCollideWithEntity(entityHit)) {
            entityHit.func_70015_d((int)this.getSize() * 5);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            Vec3d prevPos = Vec3d.field_186680_a;
            for (double theta = 0.0; theta <= 180.0; theta += 1.0) {
                double dphi = (double)(50.0f - this.getSize() * 6.0f) / Math.sin(Math.toRadians(theta));
                for (double phi = 0.0; phi < 360.0; phi += dphi) {
                    double rphi = Math.toRadians(phi);
                    double rtheta = Math.toRadians(theta);
                    double x1 = (double)this.getSize() / 2.25 * Math.cos(rphi) * Math.sin(rtheta);
                    double y1 = (double)this.getSize() / 2.25 * Math.sin(rphi) * Math.sin(rtheta);
                    double z1 = (double)this.getSize() / 2.25 * Math.cos(rtheta);
                    if (prevPos != Vec3d.field_186680_a) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).collide(true).vel(this.field_70159_w * 1.05 + this.field_70170_p.field_73012_v.nextGaussian() / 160.0, this.field_70181_x * 1.05 + this.field_70170_p.field_73012_v.nextGaussian() / 160.0, this.field_70179_y * 1.05 + this.field_70170_p.field_73012_v.nextGaussian() / 160.0).scale(this.getSize()).time(this.lifetime).pos(ArcaneUtils.getMiddleOfEntity((Entity)this).func_178787_e(new Vec3d(x1, y1, z1))).spin(0.1, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).spawn(this.field_70170_p);
                    } else {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).collide(true).vel(this.field_70159_w * 1.05 + this.field_70170_p.field_73012_v.nextGaussian() / 160.0, this.field_70181_x * 1.05 + this.field_70170_p.field_73012_v.nextGaussian() / 160.0, this.field_70179_y * 1.05 + this.field_70170_p.field_73012_v.nextGaussian() / 160.0).target(prevPos).scale(this.getSize()).time(this.lifetime).pos(ArcaneUtils.getMiddleOfEntity((Entity)this).func_178787_e(new Vec3d(x1, y1, z1))).spin(0.1, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).spawn(this.field_70170_p);
                    }
                    prevPos = new Vec3d(x1, y1, z1).func_178787_e(ArcaneUtils.getMiddleOfEntity((Entity)this));
                }
            }
        }
        int i = 0;
        while ((float)i < this.getSize() * 10.0f) {
            if (this.field_70170_p.field_72995_K) {
                AxisAlignedBB boundingBox = this.func_174813_aQ();
                double spawnX = boundingBox.field_72340_a + (double)((float)ArcaneUtils.getRandomNumberInRange(1, 10) / 10.0f) * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                double spawnY = boundingBox.field_72338_b + (double)((float)ArcaneUtils.getRandomNumberInRange(1, 10) / 10.0f) * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                double spawnZ = boundingBox.field_72339_c + (double)((float)ArcaneUtils.getRandomNumberInRange(1, 10) / 10.0f) * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).vel(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186678_a((double)(this.field_70170_p.field_73012_v.nextFloat() / 10.0f))).pos(spawnX, spawnY, spawnZ).collide(true).time(5).scale(0.75f + this.getSize() / 2.0f + this.field_70170_p.field_73012_v.nextFloat() / 2.0f).spawn(this.field_70170_p);
            }
            ++i;
        }
    }
}

