/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.entity;

import com.favouritedragon.arcaneessentials.common.entity.data.MagicConstructBehaviour;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMagicConstruct
extends electroblob.wizardry.entity.construct.EntityMagicConstruct {
    public static final DataParameter<String> SYNC_OWNER_ID = EntityDataManager.func_187226_a(EntityMagicConstruct.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityMagicConstruct.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_RENDER_SIZE = EntityDataManager.func_187226_a(EntityMagicConstruct.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<MagicConstructBehaviour> SYNC_BEHAVIOUR = EntityDataManager.func_187226_a(EntityMagicConstruct.class, MagicConstructBehaviour.DATA_SERIALIZER);
    public int lifetime = 600;
    public float damageMultiplier = 1.0f;
    private UUID casterUUID;

    public EntityMagicConstruct(World world) {
        super(world);
        this.field_70131_O = 1.0f;
        this.field_70130_N = 1.0f;
        this.field_70145_X = true;
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(size));
    }

    public float getRenderSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_RENDER_SIZE)).floatValue();
    }

    public void setRenderSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_RENDER_SIZE, (Object)Float.valueOf(size));
    }

    public MagicConstructBehaviour getBehaviour() {
        return (MagicConstructBehaviour)this.field_70180_af.func_187225_a(SYNC_BEHAVIOUR);
    }

    public void setBehaviour(MagicConstructBehaviour behaviour) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOUR, (Object)behaviour);
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SYNC_OWNER_ID, (Object)"cb2e7444-3287-4b97-adf1-e5e7ec266331");
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_RENDER_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOUR, (Object)new MagicConstructBehaviour.Idle());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBehaviour((MagicConstructBehaviour)this.getBehaviour().onUpdate(this));
        if (this.field_70173_aa > this.lifetime && this.lifetime != -1) {
            this.despawn();
        }
        this.func_70105_a(this.getSize(), this.getSize());
    }

    public void despawn() {
        this.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.casterUUID = nbttagcompound.func_186857_a("casterUUID");
        this.lifetime = nbttagcompound.func_74762_e("lifetime");
        this.damageMultiplier = nbttagcompound.func_74760_g("damageMultiplier");
    }

    protected void func_70014_b(@Nonnull NBTTagCompound nbttagcompound) {
        if (this.getCaster() != null) {
            nbttagcompound.func_186854_a("casterUUID", this.getCaster().func_110124_au());
        }
        nbttagcompound.func_74768_a("lifetime", this.lifetime);
        nbttagcompound.func_74776_a("damageMultiplier", this.damageMultiplier);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.lifetime);
    }

    public void readSpawnData(ByteBuf data) {
        this.lifetime = data.readInt();
    }

    @Nullable
    public UUID func_184753_b() {
        return this.casterUUID;
    }

    @Nullable
    public Entity func_70902_q() {
        return this.getCaster();
    }

    public void setOwner(Entity entity) {
        this.field_70180_af.func_187227_b(SYNC_OWNER_ID, (Object)entity.func_110124_au().toString());
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity entity = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.func_184753_b());
        if (entity != null && !(entity instanceof EntityLivingBase)) {
            Wizardry.logger.warn("{} has a non-living owner!", (Object)this);
            entity = null;
        }
        if (entity == null) {
            entity = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)UUID.fromString((String)this.field_70180_af.func_187225_a(SYNC_OWNER_ID)));
        }
        return (EntityLivingBase)entity;
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        UUID uUID = this.casterUUID = caster == null ? null : caster.func_110124_au();
        if (caster != null) {
            this.setOwner((Entity)caster);
        }
    }

    public boolean isValidTarget(Entity target) {
        return AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)target);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }
}

