/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.entity;

import com.favouritedragon.arcaneessentials.common.entity.EntityMagicBolt;
import com.favouritedragon.arcaneessentials.common.entity.EntityWhirlpool;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityWaterBall
extends EntityMagicBolt {
    private float damage = 5.0f;
    private boolean spawnWhirlPool;
    private boolean spawnGeysers;

    public EntityWaterBall(World world) {
        super(world);
        this.blockBoxY = this.blockBoxZ = this.getSize() / 10.0f;
        this.blockBoxX = this.blockBoxZ;
    }

    public void setSpawnWhirlPool(boolean whirlPool) {
        this.spawnWhirlPool = whirlPool;
    }

    public void setSpawnGeysers(boolean spawnGeysers) {
        this.spawnGeysers = spawnGeysers;
    }

    @Override
    protected boolean doGravity() {
        return true;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public boolean doDeceleration() {
        return false;
    }

    @Override
    public int getLifetime() {
        return 200;
    }

    private void Splash() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187547_bF, SoundCategory.PLAYERS, 1.0f + this.field_70170_p.field_73012_v.nextFloat() / 10.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() / 10.0f);
        List hit = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_186662_g((double)(this.getSize() / 2.0f)));
        if (!hit.isEmpty()) {
            for (Entity target : hit) {
                if (target == this || target == this.getCaster() || !target.func_70067_L() || this.field_70170_p.field_72995_K) continue;
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)this.getCaster(), (MagicDamage.DamageType)this.getDamageType()), (float)this.getDamage() * 0.4f);
                target.func_70024_g(this.field_70159_w / 4.0 * (double)this.getSize(), this.field_70181_x / 4.0 * (double)this.getSize(), this.field_70179_y / 4.0 * (double)this.getSize());
                ArcaneUtils.applyPlayerKnockback(target);
            }
        }
        if (this.spawnWhirlPool) {
            EntityWhirlpool pool = new EntityWhirlpool(this.field_70170_p);
            pool.setOwner((Entity)this.getCaster());
            pool.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            pool.setCaster(this.getCaster());
            pool.lifetime = 20 + (int)(this.getSize() * 10.0f);
            pool.damageMultiplier = this.damage / 7.0f;
            pool.setSize(this.getSize());
            pool.setRenderSize(this.getSize() * 1.5f);
            pool.setVortexHeight(this.getSize() * 1.5f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)pool);
            }
        }
        if (this.spawnGeysers) {
            for (int i = 0; i < 5; ++i) {
                Vec3d pos = ArcaneUtils.toRectangular(this.field_70177_z + (float)(i * 72), 0.0);
                pos = pos.func_186678_a(3.0);
                EntityWhirlpool pool = new EntityWhirlpool(this.field_70170_p);
                pool.setOwner((Entity)this.getCaster());
                pool.func_70107_b(this.field_70165_t + pos.field_72450_a, this.field_70163_u, this.field_70161_v + pos.field_72449_c);
                pool.setCaster(this.getCaster());
                pool.lifetime = 20 + (int)(this.getSize() * 10.0f);
                pool.damageMultiplier = this.damage / 10.0f;
                pool.setSize(this.getSize() / 4.0f);
                pool.setRenderSize(this.getSize() / 2.0f);
                pool.setVortexHeight(this.getSize() * 4.0f);
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_72838_d((Entity)pool);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.WATER_SPLASH, true, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40 + (int)(this.getSize() * 5.0f), 0.0, 0.0, 0.0, 0.02 + (double)(this.getSize() / 50.0f), new int[0]);
        }
        if (this.field_70170_p.field_72995_K) {
            int i = 0;
            while ((float)i < 30.0f - this.getSize()) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(this.func_174791_d()).time(10).vel(this.field_70170_p.field_73012_v.nextGaussian() / 8.0 * (double)this.getSize(), this.field_70170_p.field_73012_v.nextGaussian() / 8.0 * (double)this.getSize(), this.field_70170_p.field_73012_v.nextGaussian() / 8.0 * (double)this.getSize()).scale(0.25f + this.getSize() / 2.0f + this.field_70170_p.field_73012_v.nextFloat()).spawn(this.field_70170_p);
                ++i;
            }
            this.field_70128_L = true;
        }
    }

    @Override
    public void func_70106_y() {
        this.Splash();
        super.func_70106_y();
    }

    @Override
    public boolean canCollideWithSolid(IBlockState hit) {
        return this.getSize() < 1.0f ? hit.func_177230_c() != Blocks.field_150350_a && !(hit.func_177230_c() instanceof BlockBush) : super.canCollideWithSolid(hit);
    }
}

