/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.entity.data;

import com.favouritedragon.arcaneessentials.ArcaneEssentials;
import com.favouritedragon.arcaneessentials.common.entity.data.MagicBoltBehaviour;
import com.favouritedragon.arcaneessentials.common.entity.data.MagicConstructBehaviour;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;

public abstract class Behaviour<E extends Entity> {
    private static int nextId = 1;
    private static Map<Integer, Class<? extends Behaviour>> behaviourIdToClass;
    private static Map<Class<? extends Behaviour>, Integer> classToBehaviorId;

    public static void registerBehaviours() {
        MagicBoltBehaviour.register();
        MagicConstructBehaviour.register();
    }

    protected static int registerBehaviour(Class<? extends Behaviour> behaviourClass) {
        if (behaviourIdToClass == null) {
            behaviourIdToClass = new HashMap<Integer, Class<? extends Behaviour>>();
            classToBehaviorId = new HashMap<Class<? extends Behaviour>, Integer>();
            nextId = 1;
        }
        int id = nextId++;
        behaviourIdToClass.put(id, behaviourClass);
        classToBehaviorId.put(behaviourClass, id);
        return id;
    }

    public static Behaviour lookup(int id, Entity entity) {
        try {
            Behaviour behaviour = behaviourIdToClass.get(id).newInstance();
            return behaviour;
        }
        catch (Exception e) {
            ArcaneEssentials.logger.error("Error constructing behavior...");
            e.printStackTrace();
            return null;
        }
    }

    public int getId() {
        return classToBehaviorId.get(this.getClass());
    }

    public abstract Behaviour onUpdate(E var1);

    public abstract void fromBytes(PacketBuffer var1);

    public abstract void toBytes(PacketBuffer var1);

    public abstract void load(NBTTagCompound var1);

    public abstract void save(NBTTagCompound var1);

    public static class BehaviorSerializer<B extends Behaviour<? extends Entity>>
    implements DataSerializer<B> {
        public void write(PacketBuffer buf, B value) {
            buf.writeInt(((Behaviour)value).getId());
            ((Behaviour)value).toBytes(buf);
        }

        public B read(PacketBuffer buf) throws IOException {
            try {
                Behaviour behaviour = (Behaviour)((Class)behaviourIdToClass.get(buf.readInt())).newInstance();
                behaviour.fromBytes(buf);
                return (B)behaviour;
            }
            catch (Exception e) {
                ArcaneEssentials.logger.error("Error reading Behavior from bytes");
                e.printStackTrace();
                return null;
            }
        }

        public DataParameter<B> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public B copyValue(B behaviour) {
            return behaviour;
        }
    }
}

