/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.potion;

import com.favouritedragon.arcaneessentials.RegisterHandler;
import com.favouritedragon.arcaneessentials.common.potion.ArcanePotions;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import com.favouritedragon.arcaneessentials.common.util.DamageSources;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.potion.ISyncedPotion;
import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="arcane_essentials")
public class PotionInfernoForm
extends PotionMagicEffect
implements ISyncedPotion {
    PotionInfernoForm(boolean isBadEffect, int liquidColour) {
        super(isBadEffect, liquidColour, new ResourceLocation("arcane_essentials", "textures/gui/potion_icon_inferno_form.png"));
        this.func_76390_b("potion.arcane_essentials:inferno_form");
        this.func_188413_j();
    }

    @SubscribeEvent
    public static void handlePotion(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        if (event.getEntityLiving() != null && (entity = event.getEntityLiving()).func_70644_a(ArcanePotions.infernoForm)) {
            entity.func_82142_c(entity.func_70644_a(ArcanePotions.infernoForm));
            if (entity.field_70170_p.field_72995_K) {
                assert (entity.func_70660_b(ArcanePotions.infernoForm) != null);
                if (Objects.requireNonNull(entity.func_70660_b(ArcanePotions.infernoForm)).func_100011_g() || entity.field_70173_aa % 2 == 0) {
                    ArcaneUtils.spawnSpinningHelix(entity.field_70170_p, 60, 7.0, 0.75, ParticleBuilder.Type.MAGIC_FIRE, entity.func_174791_d(), -0.025, new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y), 20 + ArcaneUtils.getRandomNumberInRange(1, 10), -1.0f, -1.0f, -1.0f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() / 2.0f);
                }
                if (ArcaneUtils.getRandomNumberInRange(1, 20) <= 10) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)entity).time(7).clr(252, 2, 25).spawn(entity.field_70170_p);
                }
            } else {
                float radius = RegisterHandler.inferno_form.getProperty("effect_radius").floatValue();
                List nearby = entity.field_70170_p.func_72872_a(Entity.class, entity.func_174813_aQ().func_72314_b((double)radius, (double)(radius / 3.0f), (double)radius));
                if (!nearby.isEmpty()) {
                    nearby.remove(entity);
                    for (Entity hit : nearby) {
                        if (!AllyDesignationSystem.isValidTarget((Entity)entity, (Entity)hit) || !hit.func_70067_L() || !hit.func_70104_M() || hit == entity) continue;
                        if (hit instanceof EntityArrow || hit instanceof EntityThrowable && !(hit instanceof EntityMagicProjectile)) {
                            hit.func_70015_d(RegisterHandler.inferno_form.getProperty("burn_duration").intValue());
                            hit.func_70024_g(hit.field_70159_w * -1.01, 0.0, hit.field_70179_y * -1.01);
                            continue;
                        }
                        hit.func_70015_d(RegisterHandler.inferno_form.getProperty("burn_duration").intValue());
                        Vec3d vel = hit.func_174791_d().func_178788_d(entity.func_174791_d()).func_186678_a(0.1);
                        hit.func_70024_g(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
                        hit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)entity, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), RegisterHandler.inferno_form.getProperty("damage").floatValue());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving().func_70644_a(ArcanePotions.infernoForm) && ArcaneUtils.getRandomNumberInRange(0, 100) <= 25) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHurtEvent(LivingHurtEvent event) {
        EntityLivingBase attacker;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_70644_a(ArcanePotions.infernoForm) && event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).getType() == MagicDamage.DamageType.FIRE) {
            event.setAmount(event.getAmount() * 1.75f);
        }
        if (event.getEntityLiving().func_70644_a(ArcanePotions.infernoForm)) {
            if (event.getSource() == DamageSource.field_76369_e || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).getType() == DamageSources.SPLASH) {
                event.setAmount(event.getAmount() * 1.5f);
            } else if (event.getSource() instanceof IElementalDamage && (((IElementalDamage)event.getSource()).getType() == MagicDamage.DamageType.FIRE || ((IElementalDamage)event.getSource()).getType() == MagicDamage.DamageType.FROST)) {
                event.setAmount(event.getAmount() * 0.05f);
            }
        }
    }

    public boolean func_76403_b() {
        return false;
    }

    public void func_76394_a(@Nonnull EntityLivingBase entityLivingBaseIn, int amplifier) {
        super.func_76394_a(entityLivingBaseIn, amplifier);
        entityLivingBaseIn.func_70066_B();
    }
}

