/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell;

import com.favouritedragon.arcaneessentials.common.spell.IArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import net.minecraft.item.EnumAction;
import net.minecraft.util.SoundEvent;

public abstract class ArcaneSpell
extends Spell
implements IArcaneSpell {
    public static final String SWORDS = "swords";
    public static final String AXES = "axes";
    public static final String SHIELDS = "shields";

    public ArcaneSpell(String name, EnumAction action, boolean isContinuous) {
        super("arcane_essentials", name, action, isContinuous);
        this.addProperties(new String[]{SWORDS});
    }

    @Override
    public boolean isSwordCastable() {
        return this.getProperty(SWORDS).intValue() == 1;
    }

    @Override
    public boolean isWandCastable() {
        return this.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.WANDS});
    }

    @Override
    public boolean isAxeCastable() {
        return false;
    }

    @Override
    public boolean isShieldCastable() {
        return false;
    }

    protected SoundEvent[] createSounds() {
        return new SoundEvent[]{ArcaneUtils.createSound("spell." + this.getRegistryName().func_110623_a())};
    }
}

