/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell;

import com.favouritedragon.arcaneessentials.common.spell.IArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class SpellRay
extends electroblob.wizardry.spell.SpellRay
implements IArcaneSpell {
    protected Predicate<Entity> targetSelector;

    public SpellRay(String name, EnumAction action, boolean isContinuous) {
        super("arcane_essentials", name, action, isContinuous);
        this.addProperties(new String[]{"effect_radius"});
        this.targetSelector = entity -> !entity.func_190530_aW();
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.targetSelector = this.targetSelector.and(entity -> entity != caster);
        this.playSound(world, (EntityLivingBase)caster);
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.targetSelector = this.targetSelector.and(entity -> entity != caster);
        this.playSound(world, (EntityLivingBase)caster);
        return super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    public void finishCasting(World world, @Nullable EntityLivingBase caster, double x, double y, double z, @Nullable EnumFacing direction, int duration, SpellModifiers modifiers) {
        super.finishCasting(world, caster, x, y, z, direction, duration, modifiers);
        this.targetSelector = entity -> entity != caster;
    }

    public boolean isPiercing() {
        return false;
    }

    public abstract void playSound(World var1, EntityLivingBase var2);

    protected SoundEvent[] createSounds() {
        return new SoundEvent[]{ArcaneUtils.createSound("spell." + this.getRegistryName().func_110623_a())};
    }

    @Override
    public boolean isSwordCastable() {
        return this.getProperty("swords").floatValue() == 1.0f;
    }

    @Override
    public boolean isWandCastable() {
        return this.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.WANDS});
    }

    protected boolean shootSpell(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, this.targetSelector.negate());
        boolean flag = false;
        if (rayTrace != null) {
            if (rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.targetSelector = this.targetSelector.and(entity -> AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)entity));
                if (this.targetSelector.test(rayTrace.field_72308_g)) {
                    flag = this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                    if (flag) {
                        range = origin.func_72438_d(rayTrace.field_72307_f);
                    }
                    this.targetSelector = this.targetSelector.and(entity -> entity != rayTrace.field_72308_g);
                }
            } else if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                flag = this.onBlockHit(world, rayTrace.func_178782_a(), rayTrace.field_178784_b, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                range = origin.func_72438_d(rayTrace.field_72307_f);
            }
        }
        if (!flag && !this.onMiss(world, caster, origin, direction, ticksInUse, modifiers)) {
            return false;
        }
        if (flag && this.isPiercing() && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
            range = this.raytraceChain(world, origin, direction, caster, ticksInUse, modifiers);
        }
        this.targetSelector = entity -> entity != caster && AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)entity);
        if (world.field_72995_K) {
            this.spawnParticleRay(world, origin, direction, caster, range);
        }
        return true;
    }

    private double raytraceChain(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, this.targetSelector.negate());
        boolean flag = false;
        if (rayTrace != null) {
            if (rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.targetSelector = this.targetSelector.and(entity -> AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)entity));
                if (this.targetSelector.test(rayTrace.field_72308_g)) {
                    flag = this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                    this.targetSelector = this.targetSelector.and(entity -> entity != rayTrace.field_72308_g);
                }
                if (flag) {
                    range = origin.func_72438_d(rayTrace.field_72307_f);
                }
            } else if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                flag = this.onBlockHit(world, rayTrace.func_178782_a(), rayTrace.field_178784_b, rayTrace.field_72307_f, caster, origin, ticksInUse, modifiers);
                range = origin.func_72438_d(rayTrace.field_72307_f);
            }
        }
        if (flag && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.raytraceChain(world, origin, direction, caster, ticksInUse, modifiers);
        }
        return range;
    }
}

