/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.air;

import com.favouritedragon.arcaneessentials.common.entity.EntityCycloneBolt;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class CycloneBolt
extends ArcaneSpell {
    public CycloneBolt() {
        super("cyclone_bolt", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "speed", "lifetime"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, hand, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, hand, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, EnumHand hand, SpellModifiers modifiers) {
        caster.func_184609_a(hand);
        float speed = 0.5f * modifiers.get(WizardryItems.range_upgrade) + this.getProperty("speed").floatValue();
        float knockBackStrength = this.getProperty("speed").floatValue() / 6.0f * modifiers.get(WizardryItems.blast_upgrade);
        float damageMultiplier = modifiers.get("potency");
        EntityCycloneBolt bolt = new EntityCycloneBolt(world);
        bolt.setCaster(caster);
        bolt.aim(caster, speed / 20.0f, 0.0f);
        bolt.setLifetime(this.getProperty("lifetime").intValue() * 20);
        bolt.setDamage(this.getProperty("damage").floatValue() * damageMultiplier);
        bolt.setKnockbackStrength(knockBackStrength);
        caster.func_184185_a(SoundEvents.field_187631_bo, 1.5f + world.field_73012_v.nextFloat() / 10.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)bolt);
        }
        return false;
    }
}

