/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.divine;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RadianceStorm
extends ArcaneSpell {
    private static final String KNOCKBACK_MULT = "knockback_mult";
    private static final String LIGHT_BEAMS = "light_beams";
    private static final String EXPLOSION_DAMAGE = "explosion_damage";
    private static final float CENTRE_RADIUS_FRACTION = 0.5f;

    public RadianceStorm() {
        super("radiance_storm", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "effect_radius", "blast_radius", "burn_duration", KNOCKBACK_MULT, LIGHT_BEAMS, EXPLOSION_DAMAGE});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doCasting(world, (EntityLivingBase)caster, hand, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doCasting(world, (EntityLivingBase)caster, hand, modifiers);
    }

    private boolean doCasting(World world, EntityLivingBase caster, EnumHand hand, SpellModifiers modifiers) {
        if (world.func_175710_j(new BlockPos((Entity)caster))) {
            double maxRadius = this.getProperty("effect_radius").doubleValue();
            for (int i = 0; i < this.getProperty(LIGHT_BEAMS).intValue(); ++i) {
                double z;
                double radius = maxRadius * 0.5 + world.field_73012_v.nextDouble() * maxRadius * 0.5 * (double)modifiers.get(WizardryItems.blast_upgrade);
                float beamRadius = this.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
                float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                double x = caster.field_70165_t + radius * (double)MathHelper.func_76134_b((float)angle);
                Integer y = BlockUtils.getNearestFloor((World)world, (BlockPos)new BlockPos(x, caster.field_70163_u, z = caster.field_70161_v + radius * (double)MathHelper.func_76126_a((float)angle)), (int)((int)maxRadius));
                if (y != null) {
                    this.spawnRadiantBeam(world, caster, new Vec3d(x, (double)(y + 30), z), new Vec3d(x, (double)y.intValue(), z), beamRadius, this.getProperty("damage").floatValue() * modifiers.get("potency"), new Vec3d(0.5, 0.75, 0.5).func_186678_a((double)this.getProperty(KNOCKBACK_MULT).floatValue()), this.getProperty("burn_duration").intValue() * (int)modifiers.get(WizardryItems.duration_upgrade));
                }
                this.handleSphericalExplosion(world, caster, caster.func_174791_d(), (float)maxRadius * 0.5f, this.getProperty(EXPLOSION_DAMAGE).floatValue() * modifiers.get("potency"), new Vec3d(4.0, 8.0, 4.0), this.getProperty("burn_duration").intValue() * (int)modifiers.get(WizardryItems.duration_upgrade));
                caster.func_184609_a(hand);
            }
            return true;
        }
        return false;
    }

    private void spawnRadiantBeam(World world, EntityLivingBase caster, Vec3d startPos, Vec3d endPos, float radius, float damage, Vec3d knockBack, int fireTime) {
        if (!world.field_72995_K) {
            ArcaneUtils.handlePiercingBeamCollision(world, caster, startPos, endPos, radius, null, true, MagicDamage.DamageType.RADIANT, damage, knockBack, false, fireTime, radius, 0.0f, RayTracer.ignoreEntityFilter((Entity)caster));
        }
        if (world.field_72995_K) {
            ArcaneUtils.spawnSpinningHelix(world, 300, 30.0, radius - 0.1f, ParticleBuilder.Type.FLASH, endPos, 1.0, Vec3d.field_186680_a, 20, 1.0f, 1.0f, 0.3f, 1.0f);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).pos(startPos).target(endPos).scale(radius * 6.0f).clr(1.0f, 1.0f, 0.3f).fade(1.0f, 1.0f, 1.0f).time(10).spawn(world);
        }
        world.func_184134_a(endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c, WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, SoundCategory.PLAYERS, 1.25f, 1.0f, true);
        world.func_184134_a(endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c, WizardrySounds.ENTITY_HAMMER_EXPLODE, SoundCategory.PLAYERS, 1.25f, 1.0f, true);
    }

    private void handleSphericalExplosion(World world, EntityLivingBase caster, Vec3d position, float radius, float damage, Vec3d knockBackScale, int fireTime) {
        AxisAlignedBB hitBox;
        List hit;
        if (!world.field_72995_K && !(hit = world.func_72872_a(EntityLivingBase.class, hitBox = new AxisAlignedBB(position.field_72450_a - (double)radius, position.field_72448_b - (double)radius, position.field_72449_c - (double)radius, position.field_72450_a + (double)radius, position.field_72448_b + (double)radius, position.field_72449_c + (double)radius))).isEmpty()) {
            for (Entity e : hit) {
                if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)e) || e == caster || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.RADIANT, (Entity)e)) continue;
                double dx = e.field_70165_t - caster.field_70165_t;
                double dy = e.field_70163_u - caster.field_70163_u;
                double dz = e.field_70161_v - caster.field_70161_v;
                double vectorLength = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                e.field_70159_w = knockBackScale.field_72450_a * (dx /= vectorLength);
                e.field_70181_x = knockBackScale.field_72448_b * (dy /= vectorLength) + 0.1;
                e.field_70179_y = knockBackScale.field_72449_c * (dz /= vectorLength);
                e.func_70015_d(fireTime);
                e.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.RADIANT), damage);
                ArcaneUtils.applyPlayerKnockback(e);
            }
        }
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(position).scale(radius).clr(1.0f, 1.0f, 0.3f).spawn(world);
        }
    }
}

