/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.divine;

import com.favouritedragon.arcaneessentials.common.spell.SpellRay;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RadiantBeam
extends SpellRay {
    public RadiantBeam() {
        super("radiant_beam", SpellActions.POINT, false);
        this.addProperties(new String[]{"damage", "effect_strength", "burn_duration"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null) {
            Vec3d knockBack = origin == null || hit == null ? caster.func_70040_Z().func_186678_a((double)this.getProperty("effect_strength").floatValue()) : hit.func_178788_d(origin).func_186678_a(0.01 * (double)this.getProperty("effect_strength").floatValue());
            float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.RADIANT, (Entity)target) && target instanceof EntityLivingBase) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.RADIANT), damage);
                target.field_70159_w += knockBack.field_72450_a;
                target.field_70181_x += knockBack.field_72448_b;
                target.field_70179_y += knockBack.field_72449_c;
                target.func_70015_d(this.getProperty("burn_duration").intValue() * (int)modifiers.get(WizardryItems.duration_upgrade));
                ArcaneUtils.applyPlayerKnockback(target);
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        int amount = distance / (double)this.getProperty("range").floatValue() >= 1.0 ? 80 : (int)(distance / (double)this.getProperty("range").floatValue() * 80.0);
        for (int i = 0; i < amount; ++i) {
            double x1 = caster.field_70165_t + direction.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            double y1 = origin.field_72448_b + direction.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            double z1 = caster.field_70161_v + direction.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(x1, y1, z1).vel(world.field_73012_v.nextGaussian() / 120.0, world.field_73012_v.nextGaussian() / 80.0, world.field_73012_v.nextGaussian() / 120.0).time(15).clr(1.0f, 1.0f, 0.3f).spawn(world);
        }
        ArcaneUtils.spawnDirectionalHelix(world, (Entity)caster, caster.func_70040_Z(), (int)((double)amount * 2.25), distance, 0.5, ParticleBuilder.Type.SPARKLE, new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f, caster.field_70161_v), new Vec3d(world.field_73012_v.nextGaussian() / 120.0, world.field_73012_v.nextGaussian() / 80.0, world.field_73012_v.nextGaussian() / 120.0), 15, 1.0f, 1.0f, 0.3f);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).entity((Entity)caster).pos(origin.func_178788_d(caster.func_174791_d())).length(distance).clr(1.0f, 1.0f, 0.3f).fade(1.0f, 1.0f, 1.0f).scale(4.0f).time(4).spawn(world);
    }

    @Override
    public boolean isSwordCastable() {
        return true;
    }

    @Override
    public void playSound(World world, EntityLivingBase caster) {
        caster.func_184185_a(WizardrySounds.BLOCK_ARCANE_WORKBENCH_SPELLBIND, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 1.0f);
        caster.func_184185_a(WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, 1.5f + world.field_73012_v.nextFloat() / 10.0f, 0.9f + world.field_73012_v.nextFloat() / 10.0f);
    }

    @Override
    public boolean isPiercing() {
        return true;
    }
}

