/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.divine;

import com.favouritedragon.arcaneessentials.common.entity.EntityMagicConstruct;
import com.favouritedragon.arcaneessentials.common.entity.EntitySaintessSun;
import com.favouritedragon.arcaneessentials.common.entity.data.MagicConstructBehaviour;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SaintessSun
extends ArcaneSpell {
    public SaintessSun() {
        super("saintess_sun", EnumAction.BOW, false);
        this.addProperties(new String[]{"effect_radius", "burn_duration", "damage", "effect_duration"});
    }

    @Nullable
    public static void shootBeam(EntityLivingBase caster, EntitySaintessSun source, Entity target) {
        World world = source.field_70170_p;
        if (caster != null && world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).time(12 + ArcaneUtils.getRandomNumberInRange(0, 4)).clr(1.0f, 1.0f, 0.3f).entity((Entity)caster).pos(ArcaneUtils.getMiddleOfEntity((Entity)source).func_178788_d(caster.func_174791_d())).target(target.func_174791_d().func_72441_c(0.0, (double)(target.func_70047_e() / 2.0f), 0.0)).scale(source.getSize()).spawn(source.field_70170_p);
            world.func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, WizardrySounds.ENTITY_HAMMER_EXPLODE, WizardrySounds.SPELLS, 1.5f + world.field_73012_v.nextFloat() / 4.0f, 0.75f + world.field_73012_v.nextFloat() / 4.0f, true);
            world.func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, WizardrySounds.SPELLS, 1.5f + world.field_73012_v.nextFloat() / 4.0f, 0.875f + world.field_73012_v.nextFloat() / 4.0f, true);
        }
        if (caster != null && !world.field_72995_K) {
            DamageSource damageSource = MagicDamage.causeIndirectMagicDamage((Entity)source, (Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.RADIANT);
            float damage = source.getDamage();
            if (!target.func_190530_aW() && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.RADIANT, (Entity)target) && target.func_70097_a(damageSource, damage / 4.0f)) {
                target.func_70015_d(source.getFireTime());
                Vec3d entityPos = target.func_174791_d();
                Vec3d sourcePos = source.func_174791_d();
                Vec3d vel = sourcePos.func_178788_d(entityPos).func_186678_a(0.005);
                target.func_70024_g(vel.field_72450_a, vel.field_72448_b + 0.15, vel.field_72449_c);
            } else if (!target.func_70097_a(damageSource, damage) && target instanceof EntityDragon && ((EntityDragon)target).func_70965_a(((EntityDragon)target).field_70987_i, damageSource, damage)) {
                target.func_70015_d(source.getFireTime());
            }
        }
    }

    private boolean cast(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        float size = this.getProperty("effect_radius").floatValue();
        float damage = this.getProperty("damage").floatValue();
        int lifetime = this.getProperty("effect_duration").intValue();
        int fireTime = this.getProperty("burn_duration").intValue();
        lifetime = (int)((float)lifetime * modifiers.get(WizardryItems.range_upgrade));
        EntitySaintessSun sun = new EntitySaintessSun(world);
        sun.func_70107_b(caster.field_70165_t, caster.field_70163_u + (double)((size *= modifiers.get(WizardryItems.blast_upgrade)) * 4.0f), caster.field_70161_v);
        sun.setSize(size);
        sun.setDamage(damage *= modifiers.get(WizardryItems.blast_upgrade));
        sun.setFireTime(fireTime);
        sun.setLifetime(lifetime);
        sun.setBehaviour(new SaintessSunBehaviour());
        sun.setCaster(caster);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)sun);
        }
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_STORMCLOUD_THUNDER, WizardrySounds.SPELLS, 2.0f, 0.675f + world.field_73012_v.nextFloat() / 4.0f, false);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, WizardrySounds.SPELLS, 2.0f, 0.875f + world.field_73012_v.nextFloat() / 4.0f, false);
        return true;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        caster.func_184609_a(hand);
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    public static class SaintessSunBehaviour
    extends MagicConstructBehaviour {
        public MagicConstructBehaviour onUpdate(EntityMagicConstruct entity) {
            if (entity.getCaster() != null && entity instanceof EntitySaintessSun) {
                EntityLivingBase caster = entity.getCaster();
                World world = entity.field_70170_p;
                float height = entity.getSize() * 1.5f;
                Vec3d targetPos = ArcaneUtils.getEntityPos((Entity)caster).func_72441_c(0.0, (double)height, 0.0);
                Vec3d entityPos = entity.func_174791_d();
                Vec3d targetVelocity = targetPos.func_178788_d(entityPos).func_186678_a(0.1);
                entity.field_70159_w = targetVelocity.field_72450_a;
                entity.field_70181_x = targetVelocity.field_72448_b;
                entity.field_70179_y = targetVelocity.field_72449_c;
                entity.field_70133_I = true;
                List targets = world.func_72872_a(Entity.class, entity.func_174813_aQ().func_186662_g((double)(height * 1.25f)));
                if (!targets.isEmpty()) {
                    for (Entity target : targets) {
                        if (!entity.isValidTarget(target) || target == entity || target == caster || !(target instanceof EntityLivingBase) || ((EntityLivingBase)target).field_70737_aN != 0) continue;
                        SaintessSun.shootBeam(caster, (EntitySaintessSun)entity, target);
                    }
                }
                if (entity.field_70173_aa < 2) {
                    world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, WizardrySounds.ENTITY_RADIANT_TOTEM_AMBIENT, WizardrySounds.SPELLS, 3.0f, 1.5f, false);
                }
            }
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

