/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.divine;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class WaveOfRelief
extends ArcaneSpell {
    public WaveOfRelief() {
        super("wave_of_relief", EnumAction.BOW, false);
        this.addProperties(new String[]{"effect_radius", "health"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, hand, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, hand, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, EnumHand hand, SpellModifiers modifiers) {
        List nearby;
        float healAmount = modifiers.get("potency") * this.getProperty("health").floatValue();
        float radius = modifiers.get(WizardryItems.range_upgrade) * this.getProperty("effect_radius").floatValue();
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).clr(1.0f, 1.0f, 0.3f).pos(caster.func_174791_d()).time(7).scale(radius / 2.0f).spawn(world);
        }
        if (!(nearby = world.func_72872_a(EntityLivingBase.class, caster.func_174813_aQ().func_186662_g((double)radius))).isEmpty()) {
            for (EntityLivingBase ally : nearby) {
                if (ally == null || (ally.func_96124_cp() == null || ally.func_96124_cp() != caster.func_96124_cp()) && caster != ally) continue;
                List potions = ally.func_70651_bq().stream().filter(potionEffect -> potionEffect.func_188419_a().func_76398_f()).collect(Collectors.toList());
                if (!potions.isEmpty()) {
                    for (PotionEffect effect : potions) {
                        if (!effect.func_188419_a().func_76398_f()) continue;
                        ally.func_184589_d(effect.func_188419_a());
                    }
                }
                ally.func_70691_i(healAmount);
                if (ally instanceof EntityPlayer) {
                    ((EntityPlayer)ally).func_71024_bL().func_75114_a(((EntityPlayer)ally).func_71024_bL().func_75116_a() + 4);
                }
                if (!world.field_72995_K) continue;
                ParticleBuilder.spawnHealParticles((World)world, (EntityLivingBase)ally);
            }
        }
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_HEAL_AURA_AMBIENT, SoundCategory.PLAYERS, 1.5f, 0.9f + world.field_73012_v.nextFloat() / 10.0f, false);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, SoundCategory.PLAYERS, 0.675f + world.field_73012_v.nextFloat() / 10.0f, 0.875f + world.field_73012_v.nextFloat() / 10.0f, false);
        caster.func_184609_a(hand);
        return true;
    }
}

