/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.fire;

import com.favouritedragon.arcaneessentials.common.entity.EntityFlameSlash;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class FlameCleave
extends ArcaneSpell {
    public FlameCleave() {
        super("flame_cleave", EnumAction.NONE, false);
        this.addProperties(new String[]{"damage", "range", "burn_duration", "size", "effect_strength"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        float size = this.getProperty("size").floatValue();
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        int burnDuration = this.getProperty("burn_duration").intValue() * (int)modifiers.get("potency");
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 1.0f + world.field_73012_v.nextFloat(), 1.0f + world.field_73012_v.nextFloat(), false);
        EntityFlameSlash slash = new EntityFlameSlash(world);
        slash.setCaster(caster);
        slash.setSize(size);
        slash.setLifetime(20);
        slash.setKnockbackStrength(this.getProperty("effect_strength").floatValue());
        slash.setDamage(damage);
        slash.setKnockbackStrength((int)size * 2);
        slash.setBurnDuration(burnDuration);
        slash.aim(caster, this.getProperty("range").floatValue() / 50.0f, 0.0f);
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)slash);
        }
        return false;
    }

    @Override
    public boolean castRightClick() {
        return false;
    }

    @Override
    public boolean isWandCastable() {
        return false;
    }
}

