/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.fire;

import com.favouritedragon.arcaneessentials.common.entity.EntityFlamePillar;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class InfernoPillar
extends ArcaneSpell {
    public InfernoPillar() {
        super("inferno_pillar", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "effect_radius", "effect_duration", "range"});
        this.soundValues(1.5f, 0.8f, 0.15f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        int lifetime = this.getProperty("effect_duration").intValue() * 20 * (int)modifiers.get(WizardryItems.duration_upgrade);
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get("potency");
        float height = this.getProperty("range").floatValue() * modifiers.get("potency");
        world.func_72838_d((Entity)new EntityFlamePillar(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, (EntityLivingBase)caster, lifetime, damage, radius, height, 120));
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)WizardrySounds.ENTITY_FIRE_RING_AMBIENT, (float)(1.0f + world.field_73012_v.nextFloat() / 10.0f), (float)(0.5f + world.field_73012_v.nextFloat() / 10.0f));
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)WizardrySounds.ENTITY_FIRE_SIGIL_TRIGGER, (float)(1.0f + world.field_73012_v.nextFloat() / 10.0f), (float)(0.5f + world.field_73012_v.nextFloat() / 10.0f));
        caster.func_184609_a(hand);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        int lifetime = this.getProperty("effect_duration").intValue() * 20 * (int)modifiers.get(WizardryItems.duration_upgrade);
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get("potency");
        float height = this.getProperty("range").floatValue() * modifiers.get("potency");
        world.func_72838_d((Entity)new EntityFlamePillar(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, (EntityLivingBase)caster, lifetime, damage, radius, height, 120));
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_FIRE_RING_AMBIENT, SoundCategory.NEUTRAL, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 0.5f + world.field_73012_v.nextFloat() / 10.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_FIRE_SIGIL_TRIGGER, SoundCategory.NEUTRAL, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 0.5f + world.field_73012_v.nextFloat() / 10.0f, true);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean isShieldCastable() {
        return true;
    }
}

