/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.fire;

import com.favouritedragon.arcaneessentials.common.entity.EntityFireball;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class KaFrizz
extends ArcaneSpell {
    public KaFrizz() {
        super("kafrizz", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "range", "burn_duration", "size"});
        this.soundValues(1.75f, 1.0f, 0.15f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        float size = this.getProperty("size").floatValue() * modifiers.get("potency");
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        int burnDuration = this.getProperty("burn_duration").intValue() * (int)modifiers.get("potency");
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187557_bK, WizardrySounds.SPELLS, 1.0f + world.field_73012_v.nextFloat(), 1.0f + world.field_73012_v.nextFloat(), false);
        EntityFireball fireball = new EntityFireball(world);
        fireball.setCaster(caster);
        fireball.setSize(size);
        fireball.setLifetime(70);
        fireball.setDamage(damage);
        fireball.setKnockbackStrength((int)size * 2);
        fireball.setBurnDuration(burnDuration);
        fireball.aim(caster, this.getProperty("range").floatValue() / 50.0f, 0.0f);
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)fireball);
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        caster.func_184609_a(hand);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        float size = this.getProperty("size").floatValue() * modifiers.get("potency");
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        Vec3i dir = direction.func_176730_m();
        EntityFireball fireball = new EntityFireball(world);
        this.playSound(world, x, y, z, ticksInUse, -1, modifiers, new String[0]);
        fireball.setSize(size);
        fireball.setDamage(damage);
        fireball.func_70107_b(x, y, z);
        fireball.func_70186_c(dir.func_177958_n(), dir.func_177956_o(), dir.func_177952_p(), this.getProperty("range").floatValue(), 0.0f);
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)fireball);
        }
        return false;
    }
}

