/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.ice;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.block.BlockStatue;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AbsoluteZero
extends ArcaneSpell {
    public AbsoluteZero() {
        super("absolute_zero", EnumAction.BOW, false);
        this.addProperties(new String[]{"effect_strength", "effect_radius", "effect_duration"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("effect_radius").floatValue() * modifiers.get("potency");
        float particleSize = this.getProperty("effect_strength").floatValue();
        List nearby = EntityUtils.getEntitiesWithinRadius((double)range, (double)caster.field_70165_t, (double)caster.func_174813_aQ().field_72338_b, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
        nearby.remove(caster);
        if (!nearby.isEmpty()) {
            for (EntityLivingBase target : nearby) {
                if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target)) continue;
                ((BlockStatue)WizardryBlocks.ice_statue).convertToStatue((EntityLiving)target, (EntityLivingBase)caster, this.getProperty("effect_duration").intValue() * 20);
            }
        }
        if (world.field_72995_K) {
            for (int angle = 0; angle < 360; ++angle) {
                double radians = Math.toRadians(angle);
                double x = Math.cos(radians);
                double z = Math.sin(radians);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(x + caster.field_70165_t, caster.field_70163_u + 0.5, z + caster.field_70161_v).vel(x * range / 10.0, world.field_73012_v.nextGaussian() / 10.0 * range, z * range / 10.0).time(14).clr(205, 254, 255).scale(particleSize).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).entity((Entity)caster).time(6).scale((float)range * 1.25f).clr(205, 254, 255).spawn(world);
        }
        caster.func_184185_a(WizardrySounds.MISC_FREEZE, 3.0f, 1.0f);
        caster.func_184185_a(WizardrySounds.ENTITY_ICE_LANCE_SMASH, 2.0f, 1.0f);
        caster.func_184609_a(hand);
        return true;
    }
}

