/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.ice;

import com.favouritedragon.arcaneessentials.common.spell.SpellRay;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlizzardBeam
extends SpellRay {
    public BlizzardBeam() {
        super("blizzard_beam", SpellActions.POINT, false);
        this.addProperties(new String[]{"damage", "effect_duration", "effect_strength", "direct_effect_strength"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null) {
            Vec3d knockBack = hit == null || origin == null ? caster.func_70040_Z().func_186678_a((double)this.getProperty("direct_effect_strength").floatValue()) : hit.func_178788_d(origin).func_186678_a(0.01 * (double)this.getProperty("direct_effect_strength").floatValue());
            float damage = this.getProperty("damage").floatValue() + modifiers.get("potency");
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)target) && target instanceof EntityLivingBase) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), damage);
                target.field_70159_w += knockBack.field_72450_a;
                target.field_70181_x += knockBack.field_72448_b;
                target.field_70179_y += knockBack.field_72449_c;
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.frost, this.getProperty("effect_duration").intValue() * (int)modifiers.get(WizardryItems.duration_upgrade), this.getProperty("effect_strength").intValue() * (int)modifiers.get("potency")));
                ArcaneUtils.applyPlayerKnockback(target);
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        super.spawnParticleRay(world, origin, direction, caster, distance);
        Vec3d endPos = origin.func_178787_e(direction.func_186678_a(distance));
        int particles = distance / (double)this.getProperty("range").floatValue() >= 1.0 ? 180 : (int)(distance / (double)this.getProperty("range").floatValue() * 180.0);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).scale(this.getProperty("effect_radius").floatValue() * 5.0f).pos(origin).target(endPos).time(15).clr(174, 252, 255).fade(230, 253, 254).collide(true).spawn(world);
        ArcaneUtils.spawnDirectionalHelix(world, (Entity)caster, caster.func_70040_Z(), particles, distance, (double)this.getProperty("effect_radius").floatValue() * 0.8, ParticleBuilder.Type.FLASH, origin, new Vec3d(world.field_73012_v.nextGaussian() / 80.0, world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextGaussian() / 80.0), 12, 174.0f, 252.0f, 255.0f);
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public void playSound(World world, EntityLivingBase caster) {
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_ICE_SHARD_SMASH, SoundCategory.PLAYERS, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 1.0f + world.field_73012_v.nextFloat() / 10.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_ICE_CHARGE_ICE, SoundCategory.PLAYERS, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 1.0f + world.field_73012_v.nextFloat() / 10.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_ICE_GIANT_ATTACK, SoundCategory.PLAYERS, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 1.0f + world.field_73012_v.nextFloat() / 10.0f, true);
    }
}

