/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.ice;

import com.favouritedragon.arcaneessentials.common.item.weapon.ItemMagicSword;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.entity.projectile.EntityIceLance;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FrostFan
extends ArcaneSpell {
    private static final String FROST_FANS = "frost_fans";
    private static final float DISPENSER_INACCURACY = 1.0f;
    private static final float FALLBACK_VELOCITY = 2.0f;

    public FrostFan() {
        super("frost_fan", EnumAction.NONE, false);
        this.addProperties(new String[]{"damage", "range", FROST_FANS, "effect_strength"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster.func_184586_b(hand).func_77973_b() instanceof ItemMagicSword)) {
            caster.func_184609_a(hand);
        }
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        double angle;
        int fans = this.getProperty(FROST_FANS).intValue();
        double totalAngle = fans % 2 == 0 ? (double)((float)fans / 2.0f * 15.0f) - 7.5 : (double)(fans / 2 * 15);
        double d = angle = fans % 2 == 0 ? (double)((float)fans / 2.0f * -15.0f) + 7.5 : (double)(fans / 2 * -15);
        while (angle <= totalAngle) {
            EntityIceLance lance = new EntityIceLance(world);
            this.aim(caster.field_70125_A, caster.field_70177_z + (float)angle, caster, this.calculateVelocity((EntityMagicArrow)lance, modifiers, caster.func_70047_e() - 0.1f), (EntityMagicArrow)lance);
            lance.damageMultiplier = this.getProperty("damage").floatValue() * modifiers.get("potency");
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)lance);
            }
            angle += 15.0;
        }
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!(caster.func_184586_b(hand).func_77973_b() instanceof ItemMagicSword)) {
            caster.func_184609_a(hand);
        }
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return super.cast(world, x, y, z, direction, ticksInUse, duration, modifiers);
    }

    @Override
    public boolean castRightClick() {
        return false;
    }

    protected float calculateVelocity(EntityMagicArrow projectile, SpellModifiers modifiers, float launchHeight) {
        float range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        if (!projectile.doGravity()) {
            if (projectile.getLifetime() <= 0) {
                return 2.0f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.05f;
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    private void aim(float rotationPitch, float rotationYaw, EntityLivingBase caster, float speed, EntityMagicArrow projectile) {
        projectile.setCaster(caster);
        projectile.func_70012_b(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 0.1, caster.field_70161_v, rotationYaw, rotationPitch);
        projectile.field_70165_t -= (double)(MathHelper.func_76134_b((float)(projectile.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        projectile.field_70163_u -= (double)0.1f;
        projectile.field_70161_v -= (double)(MathHelper.func_76126_a((float)(projectile.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        projectile.func_70107_b(projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v);
        projectile.field_70159_w = -MathHelper.func_76126_a((float)(projectile.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(projectile.field_70125_A / 180.0f * (float)Math.PI));
        projectile.field_70181_x = -MathHelper.func_76126_a((float)(projectile.field_70125_A / 180.0f * (float)Math.PI));
        projectile.field_70179_y = MathHelper.func_76134_b((float)(projectile.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(projectile.field_70125_A / 180.0f * (float)Math.PI));
        projectile.func_70186_c(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y, speed * 1.5f, 1.0f);
    }
}

