/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.ice;

import com.favouritedragon.arcaneessentials.common.spell.SpellRay;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class IcicleStorm
extends SpellRay {
    public IcicleStorm() {
        super("icicle_storm", SpellActions.POINT, true);
        this.particleVelocity(1.0);
        this.particleJitter(0.3);
        this.particleSpacing(0.125);
        this.addProperties(new String[]{"damage", "effect_strength", "effect_duration"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)target)) {
                if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else if (ticksInUse % ((EntityLivingBase)target).field_70771_an == 1) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.frost, this.getProperty("effect_duration").intValue(), this.getProperty("effect_strength").intValue(), false, false));
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)(this.getProperty("damage").floatValue() * modifiers.get("potency")));
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos(x, y, z).vel(vx, vy, vz).scale(2.0f + world.field_73012_v.nextFloat()).collide(true).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos(x, y, z).vel(vx, vy, vz).scale(2.0f + world.field_73012_v.nextFloat()).collide(true).spawn(world);
    }

    @Override
    public void playSound(World world, EntityLivingBase caster) {
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_ICE_SHARD_SMASH, SoundCategory.PLAYERS, 0.4f + world.field_73012_v.nextFloat() / 10.0f, 0.6f + world.field_73012_v.nextFloat() / 10.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_BLIZZARD_AMBIENT, SoundCategory.PLAYERS, 0.2f + world.field_73012_v.nextFloat() / 10.0f, 0.6f + world.field_73012_v.nextFloat() / 10.0f, true);
    }

    @Override
    public boolean isAxeCastable() {
        return false;
    }

    @Override
    public boolean isShieldCastable() {
        return false;
    }

    @Override
    public boolean castRightClick() {
        return true;
    }
}

