/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.ice;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityStatue;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Shatter
extends ArcaneSpell {
    public Shatter() {
        super("shatter", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "effect_strength", "effect_radius"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("effect_radius").floatValue() * modifiers.get("potency");
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        float particleSize = this.getProperty("effect_strength").floatValue();
        int i = 0;
        while ((double)i <= range) {
            for (int angle = 0; angle < 360; ++angle) {
                double radians = Math.toRadians(angle);
                double x = (double)i * Math.cos(radians);
                double z = (double)i * Math.sin(radians);
                double y = caster.func_174813_aQ().field_72338_b - range / 2.0;
                int j = 0;
                while ((double)j <= range) {
                    TileEntityStatue statue;
                    BlockPos pos = new BlockPos(x + caster.field_70165_t, y += (double)j, z + caster.field_70161_v);
                    if (world.func_180495_p(pos).func_177230_c() == WizardryBlocks.ice_statue && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityStatue && (statue = (TileEntityStatue)world.func_175625_s(pos)) != null && statue.creature != null) {
                        EntityLiving hit = statue.creature;
                        int height = hit.field_70131_O < 1.0f ? 1 : (int)hit.field_70131_O;
                        for (int h = 0; h < height; ++h) {
                            Block block = world.func_180495_p(pos.func_177981_b(h)).func_177230_c();
                            block.func_180663_b(world, pos, world.func_180495_p(pos.func_177981_b(h)));
                            statue.setLifetime(0);
                            if (world.func_175625_s(pos.func_177981_b(h)) == null || !(world.func_175625_s(pos.func_177981_b(h)) instanceof TileEntityStatue)) continue;
                            ((TileEntityStatue)world.func_175625_s(pos.func_177981_b(h))).setLifetime(0);
                        }
                        for (int p = 0; p < 8; ++p) {
                            if (!world.field_72995_K) continue;
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE, (Random)world.field_73012_v, (double)hit.field_70165_t, (double)((double)hit.func_70047_e() + hit.func_174813_aQ().field_72338_b), (double)hit.field_70161_v, (double)(hit.func_174813_aQ().field_72336_d - hit.func_174813_aQ().field_72340_a), (boolean)true).time(20).scale(particleSize).spawn(world);
                        }
                        if (AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)hit) && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)hit) && !world.field_72995_K) {
                            hit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), damage);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        caster.func_184609_a(hand);
        return true;
    }
}

