/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.necromancy;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class KaThwack
extends ArcaneSpell {
    private static final double EPICENTRE_RADIUS = 1.0;
    private static final String DEATH_CHANCE = "death_chance";

    public KaThwack() {
        super("kathwack", EnumAction.BOW, false);
        this.soundValues(2.0f, 0.8f, 0.3f);
        this.addProperties(new String[]{"blast_radius", "damage", DEATH_CHANCE});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.doCast(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.doCast(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    private boolean doCast(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
        for (EntityLivingBase target : targets) {
            if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.WITHER, (Entity)target)) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
                return false;
            }
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target)) continue;
            float proximity = (float)(1.0 - Math.max((double)target.func_70032_d((Entity)caster) - 1.0, 0.0) / (radius - 1.0));
            float chance = ArcaneUtils.getRandomNumberInRange(1, 100);
            float healthMod = target.func_110143_aJ() / target.func_110138_aP();
            if ((double)chance > (double)(this.getProperty(DEATH_CHANCE).floatValue() + healthMod * 100.0f) / (0.5 + (double)(proximity / 2.0f)) || target.func_110143_aJ() <= this.getProperty("damage").floatValue() * proximity * modifiers.get("potency")) {
                if (!(target.func_110143_aJ() > 0.0f) && target.field_70128_L) continue;
                caster.func_70691_i(target.func_110143_aJ());
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER), (float)(target.func_110143_aJ() + 1.0f));
                if (!world.field_72995_K) continue;
                for (int i = 0; i < 80; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v).vel(world.field_73012_v.nextBoolean() ? (double)(world.field_73012_v.nextFloat() / 30.0f) : (double)(-world.field_73012_v.nextFloat() / 30.0f), (double)(world.field_73012_v.nextFloat() / 10.0f), world.field_73012_v.nextBoolean() ? (double)(world.field_73012_v.nextFloat() / 30.0f) : (double)(-world.field_73012_v.nextFloat() / 30.0f)).clr(36, 7, 71).spawn(world);
                }
                ParticleBuilder.spawnHealParticles((World)world, (EntityLivingBase)caster);
                continue;
            }
            if (world.field_72995_K) continue;
            EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER), (float)(this.getProperty("damage").floatValue() * proximity * modifiers.get("potency")));
        }
        if (world.field_72995_K) {
            int i;
            for (i = 0; i < 40; ++i) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                IBlockState block = BlockUtils.getBlockEntityIsStandingOn((Entity)caster);
                if (block == null) continue;
                world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, caster.func_174813_aQ().field_72338_b, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, new int[]{Block.func_176210_f((IBlockState)block)});
            }
            for (i = 0; i < 4; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v).scale((float)radius * 0.5f).clr(21, 0, 46).shaded(true).spawn(world);
            }
        }
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_SHADOW_WRAITH_HURT, WizardrySounds.SPELLS, 1.0f + world.field_73012_v.nextFloat(), 0.8f + world.field_73012_v.nextFloat() / 10.0f, false);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_DARKNESS_ORB_HIT, WizardrySounds.SPELLS, 1.0f + world.field_73012_v.nextFloat(), 0.8f + world.field_73012_v.nextFloat() / 10.0f, false);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_SHADOW_WRAITH_DEATH, WizardrySounds.SPELLS, 1.3f + world.field_73012_v.nextFloat() / 10.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f, false);
        caster.func_184609_a(hand);
        this.playSound(world, caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }
}

