/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.sorcery;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DragonRoar
extends ArcaneSpell {
    public DragonRoar() {
        super("dragon_roar", EnumAction.BOW, false);
        this.addProperties(new String[]{"effect_duration", "effect_strength", "effect_radius"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        caster.func_184609_a(hand);
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        int duration = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
        int amplifier = (int)(this.getProperty("effect_strength").floatValue() * modifiers.get("potency"));
        if (world.field_72995_K) {
            for (int angle = 0; angle < 360; ++angle) {
                double radians = Math.toRadians(angle);
                double x = Math.cos(radians);
                double z = Math.sin(radians);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(x + caster.field_70165_t, caster.field_70163_u + 0.5, z + caster.field_70161_v).vel(x * radius / 10.0, world.field_73012_v.nextGaussian() / 10.0 * radius, z * radius / 10.0).time(14).clr(155, 6, 185).scale((float)(radius / 2.0)).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).entity((Entity)caster).clr(155, 6, 185).time(6).scale((float)radius).spawn(world);
        }
        List<Entity> nearby = ArcaneUtils.getEntitiesWithinRadius(radius, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        nearby.remove(caster);
        for (Entity target : nearby) {
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target) || target == caster || !target.func_70067_L()) continue;
            if (target instanceof EntityLivingBase) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(WizardryPotions.paralysis, duration, amplifier));
            }
            if (world.field_72995_K) continue;
            if (target instanceof EntityArrow) {
                target.func_70024_g(target.field_70159_w * -1.2, target.field_70181_x * -1.2, target.field_70179_y * -1.2);
                continue;
            }
            if (!(target instanceof EntityThrowable) || target instanceof EntityMagicProjectile) continue;
            target.func_70024_g(target.field_70159_w * -3.0, target.field_70181_x * -3.0, target.field_70179_y * -3.0);
        }
        caster.func_184185_a(SoundEvents.field_187752_dd, 1.5f + world.field_73012_v.nextFloat() / 10.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
        caster.func_184185_a(SoundEvents.field_187525_aO, 1.5f + world.field_73012_v.nextFloat() / 10.0f, 0.75f + world.field_73012_v.nextFloat() / 10.0f);
        return true;
    }
}

