/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.sorcery;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FlashStep
extends ArcaneSpell {
    private static final IVariable<Integer> TELEPORTS = new IVariable.Variable(Persistence.DIMENSION_CHANGE);
    private static final String TELEPORT_NUMBER = "teleport_count";

    public FlashStep() {
        super("flash_step", EnumAction.BOW, false);
        this.addProperties(new String[]{"range", TELEPORT_NUMBER});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (WizardData.get((EntityPlayer)caster) != null && (WizardData.get((EntityPlayer)caster).getVariable(TELEPORTS) == null || (Integer)WizardData.get((EntityPlayer)caster).getVariable(TELEPORTS) < 1)) {
            WizardData.get((EntityPlayer)caster).setVariable(TELEPORTS, (Object)this.getProperty(TELEPORT_NUMBER).intValue());
        }
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult result = ArcaneUtils.standardEntityRayTrace(world, (EntityLivingBase)caster, null, caster.func_174791_d().func_72441_c(0.0, (double)caster.func_70047_e(), 0.0), range, false, 0.0f, true, false);
        Vec3d tPos = caster.func_70040_Z().func_186678_a(range).func_178787_e(caster.func_174791_d().func_72441_c(0.0, (double)caster.func_70047_e(), 0.0));
        if (result != null) {
            tPos = result.field_72307_f.func_72441_c(0.0, 1.0, 0.0);
        }
        if (ArcaneUtils.attemptTeleport((EntityLivingBase)caster, tPos.field_72450_a, tPos.field_72448_b, tPos.field_72449_c)) {
            EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)WizardrySounds.ENTITY_FORCE_ORB_HIT_BLOCK, (float)(1.0f + world.field_73012_v.nextFloat() / 10.0f), (float)(0.8f + world.field_73012_v.nextFloat() / 10.0f));
            caster.func_184185_a(SoundEvents.field_187534_aX, 0.5f + world.field_73012_v.nextFloat() / 10.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
        }
        WizardData.get((EntityPlayer)caster).setVariable(TELEPORTS, (Object)((Integer)WizardData.get((EntityPlayer)caster).getVariable(TELEPORTS) - 1));
        return (Integer)WizardData.get((EntityPlayer)caster).getVariable(TELEPORTS) < 1;
    }
}

