/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.sorcery;

import com.favouritedragon.arcaneessentials.common.item.weapon.ItemMagicSword;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class UnrelentingForce
extends ArcaneSpell {
    public UnrelentingForce() {
        super("unrelenting_force", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "range", "effect_strength", "effect_radius"});
        this.soundValues(5.0f, 1.125f, 0.0875f);
        this.npcSelector = this.npcSelector.or((entityLiving, aBoolean) -> entityLiving != null);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster.func_184586_b(hand).func_77973_b() instanceof ItemMagicSword)) {
            caster.func_184609_a(hand);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return this.cast(world, (EntityLivingBase)caster, hand, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!(caster.func_184586_b(hand).func_77973_b() instanceof ItemMagicSword)) {
            caster.func_184609_a(hand);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return this.cast(world, (EntityLivingBase)caster, hand, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, EnumHand hand, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        Vec3d look = caster.func_70040_Z();
        double mult = this.getProperty("effect_strength").doubleValue() * 0.5 * (double)modifiers.get("potency");
        double eyepos = (double)caster.func_70047_e() + caster.func_174813_aQ().field_72338_b;
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        if (world.field_72995_K) {
            for (int i = 0; i < 400; ++i) {
                double x1 = caster.field_70165_t + look.field_72450_a * 0.1 + world.field_73012_v.nextGaussian() / 8.0;
                double y1 = eyepos - (double)0.4f;
                double z1 = caster.field_70161_v + look.field_72449_c * 0.1 + world.field_73012_v.nextGaussian() / 8.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(x1, y1, z1).vel(look.field_72450_a * mult + world.field_73012_v.nextGaussian() / 4.0, look.field_72448_b * mult + world.field_73012_v.nextGaussian() / 4.0, look.field_72449_c * mult + world.field_73012_v.nextGaussian() / 4.0).clr(ArcaneUtils.getRandomNumberInRange(0, 255), 255, 171 + ArcaneUtils.getRandomNumberInRange(0, 84)).collide(true).time(15 + ArcaneUtils.getRandomNumberInRange(0, 10)).scale(this.getProperty("effect_strength").floatValue() / 1.5f).spawn(world);
            }
        }
        caster.func_184185_a(WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, 0.2f, world.field_73012_v.nextFloat() * 0.05f + 0.025f);
        caster.func_184185_a(SoundEvents.field_187752_dd, 0.4f, world.field_73012_v.nextFloat() / 10.0f + 0.5f);
        if (!world.field_72995_K) {
            Vec3d startPos = new Vec3d(caster.field_70165_t, eyepos, caster.field_70161_v);
            Vec3d endPos = startPos.func_178787_e(caster.func_70040_Z().func_186678_a(mult * range));
            ArcaneUtils.vortexEntityCollision(world, caster, null, startPos, endPos, this.getProperty("effect_radius").floatValue() * modifiers.get("potency"), damage, look.func_186678_a(mult / 0.6 * 2.0), MagicDamage.DamageType.FROST, true);
            return true;
        }
        return true;
    }

    @Override
    public boolean castRightClick() {
        return false;
    }
}

