/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.storm;

import com.favouritedragon.arcaneessentials.common.entity.EntityLightningVortex;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LightningVortex
extends ArcaneSpell {
    public LightningVortex() {
        super("lightning_vortex", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "range", "speed"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() + (double)(1.0f * modifiers.get(WizardryItems.range_upgrade));
        float damage = this.getProperty("damage").floatValue() + 1.0f * modifiers.get(WizardryItems.blast_upgrade);
        Vec3d vel = caster.func_70040_Z().func_186678_a(range / 20.0 * (double)this.getProperty("speed").floatValue());
        RayTraceResult result = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)range, (boolean)true);
        Vec3d pos = result != null ? result.field_72307_f : caster.func_70040_Z().func_186678_a(1.5).func_178787_e(caster.func_174791_d());
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)WizardrySounds.ENTITY_LIGHTNING_SIGIL_TRIGGER, (float)2.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187754_de, (float)1.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187752_dd, (float)2.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)new EntityLightningVortex(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel, (EntityLivingBase)caster, 100 + 10 * (int)modifiers.get(WizardryItems.duration_upgrade), damage));
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() + (double)(1.0f * modifiers.get(WizardryItems.range_upgrade));
        float damage = this.getProperty("damage").floatValue() + 1.0f * modifiers.get(WizardryItems.blast_upgrade);
        Vec3d vel = caster.func_70040_Z().func_186678_a(range / 20.0 * (double)this.getProperty("speed").floatValue());
        RayTraceResult result = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)range, (boolean)true);
        Vec3d pos = result != null ? result.field_72307_f : caster.func_70040_Z().func_186678_a(1.5).func_178787_e(caster.func_174791_d());
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityLightningVortex(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel, (EntityLivingBase)caster, 100 + 10 * (int)modifiers.get(WizardryItems.duration_upgrade), damage));
        }
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_LIGHTNING_SIGIL_TRIGGER, SoundCategory.HOSTILE, 2.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187754_de, SoundCategory.HOSTILE, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_HAMMER_THROW, SoundCategory.HOSTILE, 2.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
        return true;
    }
}

