/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.storm;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StormAssault
extends ArcaneSpell {
    private static final IVariable<SpellModifiers> STORM_MODIFIERS = new IVariable.Variable(Persistence.NEVER);
    private static final String NUMBER_OF_STRIKES = "strike_count";
    private static final double EXTRA_HIT_MARGIN = 1.0;
    private static final IVariable<Integer> ASSAULT_TIME = new IVariable.Variable(Persistence.NEVER).withTicker(StormAssault::update);

    public StormAssault() {
        super("storm_assault", EnumAction.NONE, false);
        this.addProperties(new String[]{NUMBER_OF_STRIKES, "duration", "damage", "effect_strength"});
        this.soundValues(0.6f, 1.0f, 0.0f);
    }

    private static int update(EntityPlayer player, Integer chargeTime) {
        if (chargeTime == null) {
            chargeTime = 0;
        }
        if (chargeTime > 0) {
            SpellModifiers modifiers = (SpellModifiers)WizardData.get((EntityPlayer)player).getVariable(STORM_MODIFIERS);
            if (modifiers == null) {
                modifiers = new SpellModifiers();
            }
            Vec3d look = player.func_70040_Z();
            float speed = Spells.charge.getProperty("charge_speed").floatValue() * modifiers.get(WizardryItems.range_upgrade);
            player.field_70159_w = look.field_72450_a * (double)speed;
            player.field_70179_y = look.field_72449_c * (double)speed;
            if (player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 5; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK, (Entity)player).spawn(player.field_70170_p);
                }
            }
            List collided = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(1.0));
            collided.remove(player);
            float damage = Spells.charge.getProperty("damage").floatValue() * modifiers.get("potency");
            float knockback = Spells.charge.getProperty("effect_strength").floatValue();
            collided.forEach(e -> e.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), damage));
            collided.forEach(e -> e.func_70024_g(player.field_70159_w * (double)knockback, player.field_70181_x * (double)knockback + (double)0.3f, player.field_70179_y * (double)knockback));
            if (player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, player.field_70165_t + player.field_70159_w, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v + player.field_70179_y, 0.0, 0.0, 0.0, new int[0]);
            }
            if (collided.isEmpty()) {
                Integer n = chargeTime;
                Integer n2 = chargeTime = Integer.valueOf(chargeTime - 1);
            } else {
                EntityUtils.playSoundAtPlayer((EntityPlayer)player, (SoundEvent)SoundEvents.field_187543_bD, (float)1.0f, (float)1.0f);
                chargeTime = 0;
            }
        }
        return chargeTime;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            Integer chargeTime;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            if (WizardData.get((EntityPlayer)player) != null && (chargeTime = (Integer)WizardData.get((EntityPlayer)player).getVariable(ASSAULT_TIME)) != null && chargeTime > 0 && player.func_174813_aQ().func_186662_g(1.0).func_72326_a(attacker.func_174813_aQ())) {
                event.setCanceled(true);
            }
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData.get((EntityPlayer)caster).setVariable(ASSAULT_TIME, (Object)((int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade))));
        WizardData.get((EntityPlayer)caster).setVariable(STORM_MODIFIERS, (Object)modifiers);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean isSwordCastable() {
        return true;
    }
}

