/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.storm;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class StormBlink
extends ArcaneSpell {
    public StormBlink() {
        super("storm_blink", EnumAction.BOW, false);
        this.addProperties(new String[]{"effect_radius", "range", "damage"});
        this.npcSelector = this.npcSelector.or((entityLiving, aBoolean) -> entityLiving != null);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult result = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)((float)this.getProperty("range").intValue() * modifiers.get(WizardryItems.range_upgrade)), (boolean)false);
        if (!world.field_72995_K) {
            if (result != null) {
                BlockPos pos = result.func_178782_a();
                if (caster.func_184595_k((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p())) {
                    EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187752_dd, (SoundCategory)WizardrySounds.SPELLS, (float)(2.0f + world.field_73012_v.nextFloat()), (float)(1.0f + world.field_73012_v.nextFloat()));
                    EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)WizardrySounds.ENTITY_LIGHTNING_SIGIL_TRIGGER, (SoundCategory)SoundCategory.AMBIENT, (float)4.0f, (float)1.0f);
                    List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
                    targets.remove(caster);
                    for (EntityLivingBase target : targets) {
                        if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)target)) {
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                            continue;
                        }
                        if (target == caster) continue;
                        target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), this.getProperty("damage").floatValue() * modifiers.get("potency"));
                        double dx = target.field_70165_t - caster.field_70165_t;
                        double dz = target.field_70161_v - caster.field_70161_v;
                        double vectorLength = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                        target.field_70159_w = 2.0 * (dx /= vectorLength);
                        target.field_70181_x = 0.2;
                        target.field_70179_y = 2.0 * (dz /= vectorLength);
                        if (!(target instanceof EntityPlayerMP)) continue;
                        ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)target));
                    }
                }
                return true;
            }
        } else {
            for (double theta = 0.0; theta <= 180.0; theta += 1.0) {
                double dphi = 40.0 / Math.sin(Math.toRadians(theta));
                for (double phi = 0.0; phi < 360.0; phi += dphi) {
                    double rphi = Math.toRadians(phi);
                    double rtheta = Math.toRadians(theta);
                    double x = (double)radius * Math.cos(rphi) * Math.sin(rtheta);
                    double y = (double)radius * Math.sin(rphi) * Math.sin(rtheta);
                    double z = (double)radius * Math.cos(rtheta);
                    for (int i = 0; i < 4; ++i) {
                        double px = x + world.field_73012_v.nextDouble() - 0.5;
                        double py = y + world.field_73012_v.nextDouble() - 0.5;
                        double pz = z + world.field_73012_v.nextDouble() - 0.5;
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(px + caster.field_70165_t, py + caster.func_174813_aQ().field_72338_b, pz + caster.field_70161_v).vel(world.field_73012_v.nextDouble() * 0.3 * x, world.field_73012_v.nextDouble() * 0.3 * y, world.field_73012_v.nextDouble() * 0.3 * z).time(5).spawn(world);
                    }
                }
            }
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        RayTraceResult result = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)((float)this.getProperty("range").intValue() * modifiers.get(WizardryItems.range_upgrade)), (boolean)false);
        if (!world.field_72995_K) {
            if (result != null) {
                BlockPos pos = result.func_178782_a();
                if (caster.func_184595_k((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p())) {
                    world.func_184148_a(null, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_LIGHTNING_SIGIL_TRIGGER, SoundCategory.AMBIENT, 4.0f, 2.0f);
                    List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
                    targets.remove(caster);
                    for (EntityLivingBase hit : targets) {
                        if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)hit)) {
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{hit.func_70005_c_(), this.getNameForTranslationFormatted()}));
                            continue;
                        }
                        if (hit == caster) continue;
                        hit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), this.getProperty("damage").floatValue() * modifiers.get("potency"));
                        double dx = hit.field_70165_t - caster.field_70165_t;
                        double dz = hit.field_70161_v - caster.field_70161_v;
                        double vectorLength = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                        hit.field_70159_w = 2.0 * (dx /= vectorLength);
                        hit.field_70181_x = 0.2;
                        hit.field_70179_y = 2.0 * (dz /= vectorLength);
                        if (!(hit instanceof EntityPlayerMP)) continue;
                        ((EntityPlayerMP)hit).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)hit));
                    }
                }
                return true;
            }
        } else {
            for (double theta = 0.0; theta <= 180.0; theta += 1.0) {
                double dphi = 40.0 / Math.sin(Math.toRadians(theta));
                for (double phi = 0.0; phi < 360.0; phi += dphi) {
                    double rphi = Math.toRadians(phi);
                    double rtheta = Math.toRadians(theta);
                    double x = (double)radius * Math.cos(rphi) * Math.sin(rtheta);
                    double y = (double)radius * Math.sin(rphi) * Math.sin(rtheta);
                    double z = (double)radius * Math.cos(rtheta);
                    for (int i = 0; i < 4; ++i) {
                        double px = x + world.field_73012_v.nextDouble() - 0.5;
                        double py = y + world.field_73012_v.nextDouble() - 0.5;
                        double pz = z + world.field_73012_v.nextDouble() - 0.5;
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(px + caster.field_70165_t, py + caster.func_174813_aQ().field_72338_b, pz + caster.field_70161_v).vel(world.field_73012_v.nextDouble() * 0.3 * x, world.field_73012_v.nextDouble() * 0.3 * y, world.field_73012_v.nextDouble() * 0.3 * z).time(5).spawn(world);
                    }
                }
            }
        }
        return false;
    }
}

