/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.storm;

import com.favouritedragon.arcaneessentials.common.entity.EntityLightningSpawner;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ThunderingChain
extends ArcaneSpell {
    public ThunderingChain() {
        super("thundering_chain", EnumAction.BOW, false);
        this.addProperties(new String[]{"duration", "damage", "effect_duration"});
        this.npcSelector = this.npcSelector.or((entityLiving, aBoolean) -> entityLiving != null);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return this.cast(world, (EntityLivingBase)caster, modifiers);
    }

    private boolean cast(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        int lifetime = this.getProperty("duration").intValue() + (int)(10.0f * modifiers.get(WizardryItems.duration_upgrade));
        int burnTime = this.getProperty("effect_duration").intValue() + (int)(2.0f * modifiers.get(WizardryItems.duration_upgrade));
        Vec3d look = caster.func_70040_Z();
        EntityLightningSpawner spawner = new EntityLightningSpawner(world);
        spawner.damageMultiplier = damage;
        spawner.setBurnTime(burnTime);
        spawner.setLifetime(lifetime);
        spawner.setOwner((Entity)caster);
        spawner.func_70107_b(caster.field_70165_t + look.field_72450_a * 0.25, caster.func_174813_aQ().field_72338_b, caster.field_70161_v + look.field_72449_c * 0.25);
        look = look.func_186678_a(2.0);
        spawner.field_70159_w = look.field_72450_a;
        spawner.field_70181_x = 0.0;
        spawner.field_70179_y = look.field_72449_c;
        caster.func_184185_a(WizardrySounds.ENTITY_HAMMER_THROW, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
        caster.func_184185_a(WizardrySounds.ENTITY_THUNDERBOLT_HIT, 1.0f + world.field_73012_v.nextFloat() / 10.0f, 0.8f + world.field_73012_v.nextFloat() / 10.0f);
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)spawner);
        }
        return false;
    }
}

