/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.water;

import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import com.favouritedragon.arcaneessentials.common.util.ArcaneUtils;
import com.favouritedragon.arcaneessentials.common.util.DamageSources;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class OceanBurst
extends ArcaneSpell {
    public OceanBurst() {
        super("ocean_burst", EnumAction.BOW, false);
        this.addProperties(new String[]{"damage", "range", "effect_strength", "effect_radius"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        Vec3d look = caster.func_70040_Z();
        double mult = this.getProperty("effect_strength").doubleValue() * 0.6 * (double)modifiers.get("potency");
        double eyepos = (double)caster.func_70047_e() + caster.func_174813_aQ().field_72338_b;
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        if (world.field_72995_K) {
            for (int i = 0; i < 80; ++i) {
                double x1 = caster.field_70165_t + look.field_72450_a + (double)(world.field_73012_v.nextFloat() / 10.0f) - (double)0.05f;
                double y1 = eyepos - (double)0.4f + (double)(world.field_73012_v.nextFloat() / 10.0f) - (double)0.05f;
                double z1 = caster.field_70161_v + look.field_72449_c + (double)(world.field_73012_v.nextFloat() / 10.0f) - (double)0.05f;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x1, y1, z1).vel(look.field_72450_a * mult * (double)ArcaneUtils.getRandomNumberInRange(1, 100) / 30.0 + (double)((float)ArcaneUtils.getRandomNumberInRange(-10, 10) / 40.0f), look.field_72448_b * mult * (double)ArcaneUtils.getRandomNumberInRange(1, 100) / 30.0 + (double)((float)ArcaneUtils.getRandomNumberInRange(-10, 10) / 40.0f), look.field_72449_c * mult * (double)ArcaneUtils.getRandomNumberInRange(1, 100) / 30.0 + (double)((float)ArcaneUtils.getRandomNumberInRange(-10, 10) / 40.0f)).face(caster.field_70177_z, caster.field_70125_A).spawn(world);
            }
        }
        if (!world.field_72995_K) {
            Vec3d startPos = new Vec3d(caster.field_70165_t, eyepos, caster.field_70161_v);
            Vec3d endPos = startPos.func_178787_e(caster.func_70040_Z().func_186678_a(mult * range));
            ArcaneUtils.vortexEntityCollision(world, (EntityLivingBase)caster, null, startPos, endPos, this.getProperty("effect_radius").floatValue() * modifiers.get("potency"), damage, look.func_186678_a(mult / 0.6 * 2.0), DamageSources.SPLASH, true);
            EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187549_bG, (float)2.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
            EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187547_bF, (float)0.8f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
            EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)WizardrySounds.ENTITY_FORCE_ORB_HIT, (float)2.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
            return true;
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        double range = this.getProperty("range").doubleValue() * (double)modifiers.get(WizardryItems.range_upgrade);
        Vec3d look = caster.func_70040_Z();
        double mult = this.getProperty("effect_strength").doubleValue() * 0.6 * (double)modifiers.get("potency");
        double eyepos = (double)caster.func_70047_e() + caster.func_174813_aQ().field_72338_b;
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        if (world.field_72995_K) {
            for (int i = 0; i < 80; ++i) {
                double x1 = caster.field_70165_t + look.field_72450_a + (double)(world.field_73012_v.nextFloat() / 10.0f) - (double)0.05f;
                double y1 = eyepos - (double)0.4f + (double)(world.field_73012_v.nextFloat() / 10.0f) - (double)0.05f;
                double z1 = caster.field_70161_v + look.field_72449_c + (double)(world.field_73012_v.nextFloat() / 10.0f) - (double)0.05f;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x1, y1, z1).vel(look.field_72450_a * mult * (double)ArcaneUtils.getRandomNumberInRange(1, 100) / 30.0 + (double)((float)ArcaneUtils.getRandomNumberInRange(-10, 10) / 40.0f), look.field_72448_b * mult * (double)ArcaneUtils.getRandomNumberInRange(1, 100) / 30.0 + (double)((float)ArcaneUtils.getRandomNumberInRange(-10, 10) / 40.0f), look.field_72449_c * mult * (double)ArcaneUtils.getRandomNumberInRange(1, 100) / 30.0 + (double)((float)ArcaneUtils.getRandomNumberInRange(-10, 10) / 40.0f)).face(caster.field_70177_z, caster.field_70125_A).spawn(world);
            }
        }
        if (!world.field_72995_K) {
            Vec3d startPos = new Vec3d(caster.field_70165_t, eyepos, caster.field_70161_v);
            Vec3d endPos = startPos.func_178787_e(caster.func_70040_Z().func_186678_a(mult * range));
            ArcaneUtils.vortexEntityCollision(world, (EntityLivingBase)caster, null, startPos, endPos, this.getProperty("effect_radius").floatValue() * modifiers.get("potency"), damage, look.func_186678_a(mult / 0.6), DamageSources.SPLASH, true);
            world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187549_bG, SoundCategory.HOSTILE, 2.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
            world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187547_bF, SoundCategory.HOSTILE, 0.8f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
            world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, WizardrySounds.ENTITY_FORCE_ARROW_HIT, SoundCategory.HOSTILE, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean castRightClick() {
        return false;
    }
}

