/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.spell.water;

import com.favouritedragon.arcaneessentials.common.entity.EntityWhirlpool;
import com.favouritedragon.arcaneessentials.common.spell.ArcaneSpell;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Whirlpool
extends ArcaneSpell {
    public Whirlpool() {
        super("whirlpool", EnumAction.BOW, false);
        this.addProperties(new String[]{"range", "damage"});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        RayTraceResult result = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)range, (boolean)true);
        Vec3d pos = result != null ? result.field_72307_f : caster.func_174791_d();
        EntityWhirlpool pool = new EntityWhirlpool(world);
        pool.setOwner((Entity)caster);
        pool.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        pool.setCaster((EntityLivingBase)caster);
        pool.lifetime = 80 + 10 * (int)modifiers.get(WizardryItems.duration_upgrade);
        pool.damageMultiplier = damage;
        pool.setRenderSize(2.0f);
        pool.setVortexHeight(3.0f);
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187917_gq, (float)2.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187806_ee, (float)1.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
        EntityUtils.playSoundAtPlayer((EntityPlayer)caster, (SoundEvent)SoundEvents.field_187547_bF, (float)2.0f, (float)(world.field_73012_v.nextFloat() * 0.2f + 1.0f));
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)pool);
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        double range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
        RayTraceResult result = RayTracer.standardBlockRayTrace((World)world, (EntityLivingBase)caster, (double)range, (boolean)true);
        Vec3d pos = result != null ? result.field_72307_f : caster.func_174791_d();
        EntityWhirlpool pool = new EntityWhirlpool(world);
        pool.setOwner((Entity)caster);
        pool.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        pool.setCaster((EntityLivingBase)caster);
        pool.lifetime = 80 + 10 * (int)modifiers.get(WizardryItems.duration_upgrade);
        pool.damageMultiplier = damage;
        pool.setRenderSize(2.0f);
        pool.setVortexHeight(3.0f);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187917_gq, SoundCategory.HOSTILE, 2.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187806_ee, SoundCategory.HOSTILE, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
        world.func_184134_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187547_bF, SoundCategory.HOSTILE, 2.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f, true);
        if (!world.field_72995_K) {
            return world.func_72838_d((Entity)pool);
        }
        return false;
    }
}

