/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.util;

import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ArcaneUtils {
    public static Vec3d rotateAroundAxisX(Vec3d v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.field_72448_b * cos - v.field_72449_c * sin;
        double z = v.field_72448_b * sin + v.field_72449_c * cos;
        return new Vec3d(v.field_72450_a, y, z);
    }

    public static Vec3d rotateAroundAxisY(Vec3d v, double angle) {
        angle = -angle;
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.field_72450_a * cos + v.field_72449_c * sin;
        double z = v.field_72450_a * -sin + v.field_72449_c * cos;
        return new Vec3d(x, v.field_72448_b, z);
    }

    public static Vec3d rotateAroundAxisZ(Vec3d v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.field_72450_a * cos - v.field_72448_b * sin;
        double y = v.field_72450_a * sin + v.field_72448_b * cos;
        return new Vec3d(x, y, v.field_72449_c);
    }

    public static Vec3d getMiddleOfEntity(Entity entity) {
        double x = entity.func_174813_aQ().field_72336_d - entity.func_174813_aQ().field_72340_a;
        double y = entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b;
        double z = entity.func_174813_aQ().field_72334_f - entity.func_174813_aQ().field_72339_c;
        return new Vec3d(x / 2.0 + entity.func_174813_aQ().field_72340_a, y / 2.0 + entity.func_174813_aQ().field_72338_b, z / 2.0 + entity.func_174813_aQ().field_72339_c);
    }

    public static Vec3d getEntityPos(Entity entity) {
        double x = entity.func_174813_aQ().field_72336_d - entity.func_174813_aQ().field_72340_a;
        double z = entity.func_174813_aQ().field_72334_f - entity.func_174813_aQ().field_72339_c;
        return new Vec3d(x / 2.0 + entity.func_174813_aQ().field_72340_a, entity.func_174813_aQ().field_72338_b, z / 2.0 + entity.func_174813_aQ().field_72339_c);
    }

    public static void spawnDirectionalHorizontalBlade(World world, Entity entity, Vec3d direction, double particleController, double bladeLength, int entityLifetime, ResourceLocation type, Vec3d pos, Vec3d vel, float[] rgb, float size, int lifetime) {
        if (!world.field_72995_K) {
            return;
        }
        direction = direction == null ? Vec3d.field_186680_a : direction;
        int amount = (int)(30L * Math.round(bladeLength) + (long)entityLifetime);
        for (double i = 0.0; i < (double)amount; i += particleController) {
            Vec3d spawnPos = ArcaneUtils.toRectangular(Math.toRadians((double)(entity.field_70125_A - (float)amount / 2.0f) + i), 0.0);
            if (rgb[0] == -1.0f && rgb[1] == -1.0f && rgb[2] == -1.0f) {
                ParticleBuilder.create((ResourceLocation)type).time(lifetime).vel(vel).pos(spawnPos.func_178787_e(pos.func_178787_e(direction))).scale(size).collide(true).spawn(world);
                continue;
            }
            ParticleBuilder.create((ResourceLocation)type).time(lifetime).vel(vel).pos(spawnPos.func_178787_e(pos.func_178787_e(direction))).scale(size).clr(rgb[0], rgb[1], rgb[2]).collide(true).spawn(world);
        }
    }

    public static void spawnDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int particleAmount, double vortexLength, double minRadius, double radiusScale, EnumParticleTypes particle, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        for (int angle = 0; angle < particleAmount; ++angle) {
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)particleAmount / vortexLength);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(x, y, z);
            if (entity != null && direction != null) {
                pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
                pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
                world.func_175682_a(particle, true, pos.field_72450_a + posX + direction.field_72450_a, pos.field_72448_b + posY + direction.field_72448_b, pos.field_72449_c + posZ + direction.field_72449_c, velX, velY, velZ, new int[0]);
                continue;
            }
            world.func_175682_a(particle, false, x + posX, y + posY, z + posZ, velX, velY, velZ, new int[0]);
        }
    }

    public static void spawnDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double minRadius, double radiusScale, ResourceLocation particle, double posX, double posY, double posZ, double velX, double velY, double velZ, int maxAge, float r, float g, float b) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
        }
    }

    public static void spawnSpinningDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double minRadius, double radiusScale, ResourceLocation particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed, int maxAge, float r, float g, float b) {
        if (!world.field_72995_K) {
            return;
        }
        for (int angle = 0; angle < maxAngle; ++angle) {
            double newAngle = Math.toRadians(angle);
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double radius = minRadius + newAngle / radiusScale;
            double x = radius * Math.cos(newAngle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(newAngle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            angle2 += omega;
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            Vec3d pVel = new Vec3d(particleSpeed.field_72450_a * radius * omega * Math.cos(angle2), particleSpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2));
            pVel = ArcaneUtils.rotateAroundAxisX(pVel, entity.field_70125_A - 90.0f);
            pVel = ArcaneUtils.rotateAroundAxisY(pVel, entity.field_70177_z);
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            if (r == -1.0f && g == -1.0f && b == -1.0f) {
                ParticleBuilder.create((ResourceLocation)particle).pos(pos.func_178787_e(position).func_178787_e(direction)).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).spawn(world);
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).pos(pos.func_178787_e(position).func_178787_e(direction)).clr(r, g, b).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).spawn(world);
        }
    }

    public static void spawnSpinningDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double minRadius, double radiusScale, ResourceLocation particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed, int maxAge, float r, float g, float b, float scale) {
        if (!world.field_72995_K) {
            return;
        }
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            angle2 += omega;
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            Vec3d pVel = new Vec3d(particleSpeed.field_72450_a * radius * omega * Math.cos(angle2), particleSpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2));
            pVel = ArcaneUtils.rotateAroundAxisX(pVel, entity.field_70125_A - 90.0f);
            pVel = ArcaneUtils.rotateAroundAxisY(pVel, entity.field_70177_z);
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            if (r == -1.0f && g == -1.0f && b == -1.0f) {
                ParticleBuilder.create((ResourceLocation)particle).pos(pos.func_178787_e(position).func_178787_e(direction)).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).collide(true).scale(scale).spawn(world);
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).pos(pos.func_178787_e(position).func_178787_e(direction)).clr(r, g, b).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).scale(scale).collide(true).spawn(world);
        }
    }

    public static void spawnSpinningDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double minRadius, double radiusScale, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            angle2 += omega;
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            Vec3d pVel = new Vec3d(particleSpeed.field_72450_a * radius * omega * Math.cos(angle2), particleSpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2));
            pVel = ArcaneUtils.rotateAroundAxisX(pVel, entity.field_70125_A - 90.0f);
            pVel = ArcaneUtils.rotateAroundAxisY(pVel, entity.field_70177_z);
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            world.func_175682_a(particle, true, pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72448_b + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c, pVel.field_72450_a + entitySpeed.field_72450_a, pVel.field_72448_b + entitySpeed.field_72448_b, pVel.field_72449_c + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnSpinningVortex(World world, int maxAngle, double vortexHeight, double minRadius, double radiusScale, ResourceLocation particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed, int maxAge, float r, float g, float b) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d prevpos = position;
        for (int angle = 0; angle < maxAngle; ++angle) {
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexHeight);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(position.field_72450_a + x, position.field_72448_b + y, position.field_72449_c + z);
            if (particle.equals((Object)ParticleBuilder.Type.LIGHTNING)) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).vel(entitySpeed).spin(radius, ArcaneUtils.getMagnitude(particleSpeed)).time(maxAge).clr(r, g, b).target(prevpos).pos(pos).spawn(world);
                prevpos = pos;
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).vel(entitySpeed).spin(radius, ArcaneUtils.getMagnitude(particleSpeed)).time(maxAge).clr(r, g, b).pos(pos).spawn(world);
        }
    }

    public static void spawnSpinningVortex(World world, int maxAngle, double vortexHeight, double minRadius, double radiusScale, ResourceLocation particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed, int maxAge, float r, float g, float b, float scale) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d prevpos = position;
        for (int angle = 0; angle < maxAngle; ++angle) {
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexHeight);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(position.field_72450_a + x, position.field_72448_b + y, position.field_72449_c + z);
            if (particle.equals((Object)ParticleBuilder.Type.LIGHTNING)) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).vel(entitySpeed).spin(radius, ArcaneUtils.getMagnitude(particleSpeed)).time(maxAge).clr(r, g, b).target(prevpos).pos(pos).scale(scale).spawn(world);
                prevpos = pos;
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).vel(entitySpeed).spin(radius, ArcaneUtils.getMagnitude(particleSpeed)).time(maxAge).clr(r, g, b).pos(pos).scale(scale).collide(true).spawn(world);
        }
    }

    public static void spawnSpinningVortex(World world, int maxAngle, double vortexHeight, double minRadius, double radiusScale, ResourceLocation particle, Vec3d position, double particleSpeed, Vec3d entitySpeed, int maxAge) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d prevpos = position;
        for (int angle = 0; angle < maxAngle; ++angle) {
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = vortexHeight * (double)((float)angle / (float)maxAngle);
            y = MathHelper.func_151237_a((double)y, (double)0.0, (double)vortexHeight);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(position.field_72450_a + x, position.field_72448_b + y, position.field_72449_c + z);
            if (particle.equals((Object)ParticleBuilder.Type.LIGHTNING)) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).vel(entitySpeed).spin(radius, particleSpeed).time(maxAge).target(prevpos).pos(pos).spawn(world);
                prevpos = pos;
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).vel(entitySpeed).spin(radius, particleSpeed).time(maxAge).pos(pos).spawn(world);
        }
    }

    public static void spawnSpinningVortex(World world, int maxAngle, double vortexHeight, double minRadius, double radiusScale, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = vortexHeight * (double)((float)angle / (float)maxAngle);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            world.func_175682_a(particle, false, x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c, particleSpeed.field_72450_a * radius * omega * Math.cos(angle2 += omega) + entitySpeed.field_72450_a, particleSpeed.field_72448_b + entitySpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2) + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnDirectionalHelix(World world, Entity entity, Vec3d direction, int maxAngle, double vortexLength, double radius, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed) {
        if (!world.field_72995_K) {
            return;
        }
        for (int angle = 0; angle < maxAngle; ++angle) {
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(x, y, z);
            if (entity != null && direction != null) {
                pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
                pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
                world.func_175682_a(particle, true, pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72449_c + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c, particleSpeed.field_72449_c, particleSpeed.field_72448_b, particleSpeed.field_72449_c, new int[0]);
                continue;
            }
            world.func_175682_a(particle, false, x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c, particleSpeed.field_72449_c, particleSpeed.field_72448_b, particleSpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnDirectionalHelix(World world, Entity entity, Vec3d direction, int maxAngle, double vortexLength, double radius, ResourceLocation particle, Vec3d position, Vec3d particleSpeed, int maxAge, float r, float g, float b) {
        if (!world.field_72995_K) {
            return;
        }
        for (int angle = 0; angle < maxAngle; ++angle) {
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            if (r == -1.0f && g == -1.0f && b == -1.0f) {
                ParticleBuilder.create((ResourceLocation)particle).pos(pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72448_b + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c).vel(particleSpeed).time(maxAge).spawn(world);
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).pos(pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72448_b + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c).vel(particleSpeed).time(maxAge).clr(r, g, b).spawn(world);
        }
    }

    public static void spawnSpinningDirectionalHelix(World world, Entity entity, Vec3d direction, Vec3d entitySpeed, int maxAngle, double vortexLength, double radius, ResourceLocation particle, Vec3d position, Vec3d particleSpeed, int maxAge, float r, float g, float b) {
        if (!world.field_72995_K) {
            return;
        }
        Vec3d prevPos = position;
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            angle2 += omega;
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            Vec3d pVel = new Vec3d(particleSpeed.field_72450_a * radius * omega * Math.cos(angle2), particleSpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2));
            pVel = ArcaneUtils.rotateAroundAxisX(pVel, entity.field_70125_A + 90.0f);
            pVel = ArcaneUtils.rotateAroundAxisY(pVel, entity.field_70177_z);
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            if (r == -1.0f && b == -1.0f && g == -1.0f) {
                if (particle == ParticleBuilder.Type.LIGHTNING || particle == ParticleBuilder.Type.BEAM || particle == ParticleBuilder.Type.VINE) {
                    ParticleBuilder.create((ResourceLocation)particle).pos(position.func_178787_e(pos).func_178787_e(direction)).vel(pVel.func_178787_e(entitySpeed)).entity(entity).time(maxAge).target(prevPos).spawn(world);
                    prevPos = position.func_178787_e(pos).func_178787_e(direction);
                    continue;
                }
                ParticleBuilder.create((ResourceLocation)particle).pos(position.func_178787_e(pos).func_178787_e(direction)).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).spawn(world);
                continue;
            }
            if (particle == ParticleBuilder.Type.LIGHTNING || particle == ParticleBuilder.Type.BEAM || particle == ParticleBuilder.Type.VINE) {
                ParticleBuilder.create((ResourceLocation)particle).pos(position.func_178787_e(pos).func_178787_e(direction)).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).entity(entity).target(prevPos).clr(r, g, b).spawn(world);
                prevPos = position.func_178787_e(pos).func_178787_e(direction);
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).pos(position.func_178787_e(pos).func_178787_e(direction)).vel(pVel.func_178787_e(entitySpeed)).time(maxAge).clr(r, g, b).spawn(world);
        }
    }

    public static void spawnSpinningHelix(World world, int maxAngle, double vortexLength, double radius, ResourceLocation particle, Vec3d position, double particleSpeed, Vec3d entitySpeed, int maxAge, float r, float g, float b, float scale) {
        if (!world.field_72995_K) {
            return;
        }
        for (int angle = 0; angle < maxAngle; ++angle) {
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            if (r == -1.0f && g == -1.0f && b == -1.0f) {
                ParticleBuilder.create((ResourceLocation)particle).pos(x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c).spin(radius, particleSpeed).vel(entitySpeed.func_186678_a(particleSpeed)).time(maxAge).scale(scale).spawn(world);
                continue;
            }
            ParticleBuilder.create((ResourceLocation)particle).pos(x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c).clr(r, g, b).spin(radius, particleSpeed).vel(entitySpeed.func_186678_a(particleSpeed)).time(maxAge).scale(scale).spawn(world);
        }
    }

    public static void spawnSpinningHelix(World world, int maxAngle, double vortexLength, double radius, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            world.func_175688_a(particle, x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c, particleSpeed.field_72450_a * radius * omega * Math.cos(angle2 += omega) + entitySpeed.field_72450_a, particleSpeed.field_72448_b + entitySpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2) + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static void vortexEntityCollision(World world, EntityLivingBase entity, Entity spellEntity, Vec3d startPos, Vec3d endPos, float maxRadius, float damage, Vec3d knockBack, MagicDamage.DamageType damageSource, boolean directDamage) {
        if (entity != null) {
            AxisAlignedBB hitBox = new AxisAlignedBB(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c, endPos.field_72450_a, endPos.field_72448_b, endPos.field_72449_c);
            List hit = world.func_72872_a(EntityLivingBase.class, hitBox = hitBox.func_186662_g((double)maxRadius));
            if (!hit.isEmpty()) {
                for (Entity e : hit) {
                    if (e == entity) continue;
                    if (directDamage) {
                        e.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)entity, (MagicDamage.DamageType)damageSource), damage);
                        e.field_70159_w += knockBack.field_72450_a;
                        e.field_70181_x += knockBack.field_72448_b + 0.2;
                        e.field_70179_y += knockBack.field_72449_c;
                        ArcaneUtils.applyPlayerKnockback(e);
                        continue;
                    }
                    if (spellEntity == null) continue;
                    e.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)spellEntity, (Entity)entity, (MagicDamage.DamageType)damageSource), damage);
                    e.field_70159_w += knockBack.field_72450_a;
                    e.field_70181_x += knockBack.field_72448_b + 0.2;
                    e.field_70179_y += knockBack.field_72449_c;
                    ArcaneUtils.applyPlayerKnockback(e);
                }
            }
        }
    }

    public static void vortexEntityRaytrace(World world, EntityLivingBase entity, Entity spellEntity, Vec3d startPos, double vortexLength, float maxRadius, float damage, Vec3d knockBack, MagicDamage.DamageType damageSource, boolean directDamage) {
        EntityLivingBase hit;
        RayTraceResult result;
        if (entity != null && (result = ArcaneUtils.standardEntityRayTrace(world, entity, spellEntity, startPos, vortexLength, false, maxRadius, true, false)) != null && result.field_72308_g != null && result.field_72308_g instanceof EntityLivingBase && (hit = (EntityLivingBase)result.field_72308_g) != entity) {
            if (directDamage) {
                hit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)entity, (MagicDamage.DamageType)damageSource), damage);
                hit.field_70159_w += knockBack.field_72450_a;
                hit.field_70181_x += knockBack.field_72448_b + 0.2;
                hit.field_70179_y += knockBack.field_72449_c;
                ArcaneUtils.applyPlayerKnockback((Entity)hit);
            } else if (spellEntity != null) {
                hit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)spellEntity, (Entity)entity, (MagicDamage.DamageType)damageSource), damage);
                hit.field_70159_w += knockBack.field_72450_a;
                hit.field_70181_x += knockBack.field_72448_b + 0.2;
                hit.field_70179_y += knockBack.field_72449_c;
                ArcaneUtils.applyPlayerKnockback((Entity)hit);
            }
        }
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, Vec3d startPos, Vec3d endPos, Predicate<? super Entity> filter, boolean hitLiquids, float borderSize, boolean ignoreUncollidables, boolean returnLastUncollidable) {
        return RayTracer.rayTrace((World)world, (Vec3d)startPos, (Vec3d)endPos, (float)borderSize, (boolean)hitLiquids, (boolean)ignoreUncollidables, (boolean)returnLastUncollidable, Entity.class, filter);
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, EntityLivingBase entity, Entity spellEntity, Vec3d startPos, double range, boolean hitLiquids, float borderSize, boolean ignoreUncollidables, boolean returnLastUncollidable) {
        float dx = (float)entity.func_70040_Z().field_72450_a * (float)range;
        float dy = (float)entity.func_70040_Z().field_72448_b * (float)range;
        float dz = (float)entity.func_70040_Z().field_72449_c * (float)range;
        return RayTracer.rayTrace((World)world, (Vec3d)startPos, (Vec3d)new Vec3d(startPos.field_72450_a + (double)dx, startPos.field_72448_b + (double)dy, startPos.field_72449_c + (double)dz), (float)borderSize, (boolean)hitLiquids, (boolean)ignoreUncollidables, (boolean)returnLastUncollidable, Entity.class, entity1 -> entity1 == entity || entity1 == spellEntity);
    }

    public static void applyPlayerKnockback(Entity target) {
        if (target instanceof EntityPlayerMP) {
            ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
        }
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vec3d toRectangular(double yaw, double pitch) {
        return new Vec3d(-Math.sin(yaw) * Math.cos(pitch), -Math.sin(pitch), Math.cos(yaw) * Math.cos(pitch));
    }

    public static Vec3d getDirectionalVortexEndPos(EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double radiusScale, double posX, double posY, double posZ) {
        double radius = (double)maxAngle / radiusScale;
        double x = radius * Math.cos(maxAngle);
        double z = radius * Math.sin(maxAngle);
        Vec3d pos = new Vec3d(x, vortexLength, z);
        if (entity != null && direction != null) {
            pos = ArcaneUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = ArcaneUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            return new Vec3d(pos.field_72450_a + posX + direction.field_72450_a, pos.field_72448_b + posY + direction.field_72448_b, pos.field_72449_c + posZ + direction.field_72449_c);
        }
        return new Vec3d(x + posX, vortexLength + posY, z + posZ);
    }

    public static void handlePiercingBeamCollision(World world, EntityLivingBase caster, Vec3d startPos, Vec3d endPos, float borderSize, Entity spellEntity, boolean directDamage, MagicDamage.DamageType damageType, float damage, Vec3d knockBack, boolean invulnerable, int fireTime, float radius, float lifeSteal, Predicate<? super Entity> filter) {
        RayTraceResult result;
        filter = filter.or(e -> e == caster);
        if (spellEntity != null) {
            filter = filter.or(e -> e == spellEntity);
        }
        if ((result = ArcaneUtils.standardEntityRayTrace(world, startPos, endPos, filter, false, borderSize, true, false)) != null && result.field_72308_g instanceof EntityLivingBase && !filter.test(result.field_72308_g)) {
            EntityLivingBase hit = (EntityLivingBase)result.field_72308_g;
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)damageType, (Entity)hit)) {
                hit.func_70015_d(fireTime);
                caster.func_70691_i(damage * lifeSteal);
                if (directDamage) {
                    hit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)damageType), damage);
                } else if (spellEntity != null) {
                    hit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)spellEntity, (Entity)caster, (MagicDamage.DamageType)damageType), damage);
                }
                Vec3d kM = endPos.func_178788_d(startPos).func_186678_a(0.01);
                hit.field_70159_w += knockBack.field_72450_a * kM.field_72450_a;
                hit.field_70181_x += knockBack.field_72448_b * kM.field_72448_b;
                hit.field_70179_y += knockBack.field_72449_c * kM.field_72449_c;
                if (!(hit instanceof EntityPlayer && ((EntityPlayer)hit).func_184812_l_() || !hit.func_190530_aW())) {
                    hit.func_184224_h(false);
                }
                ArcaneUtils.applyPlayerKnockback((Entity)hit);
                filter = filter.or(e -> e == hit);
            }
            Vec3d pos = hit.func_174791_d().func_72441_c(0.0, (double)hit.func_70047_e(), 0.0);
            AxisAlignedBB hitBox = new AxisAlignedBB(pos.field_72450_a + (double)radius, pos.field_72448_b + (double)radius, pos.field_72449_c + (double)radius, pos.field_72450_a - (double)radius, pos.field_72448_b - (double)radius, pos.field_72449_c - (double)radius);
            List nearby = world.func_72872_a(EntityLivingBase.class, hitBox);
            nearby.removeIf(filter);
            if (!nearby.isEmpty()) {
                for (Entity secondHit : nearby) {
                    if (secondHit != caster && secondHit != hit && secondHit.func_96124_cp() != caster.func_96124_cp() && !MagicDamage.isEntityImmune((MagicDamage.DamageType)damageType, (Entity)secondHit)) {
                        secondHit.func_70015_d(fireTime);
                        if (directDamage) {
                            secondHit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)damageType), damage);
                        } else if (spellEntity != null) {
                            secondHit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)spellEntity, (Entity)caster, (MagicDamage.DamageType)damageType), damage);
                        }
                        secondHit.field_70159_w += knockBack.field_72450_a;
                        secondHit.field_70181_x += knockBack.field_72448_b;
                        secondHit.field_70179_y += knockBack.field_72449_c;
                        ArcaneUtils.applyPlayerKnockback(secondHit);
                        filter = filter.or(e -> e == secondHit);
                    }
                    if (secondHit.func_96124_cp() != caster.func_96124_cp() || damageType != MagicDamage.DamageType.RADIANT || !(secondHit instanceof EntityLivingBase)) continue;
                    ((EntityLivingBase)secondHit).func_70691_i(damage);
                }
            } else {
                ArcaneUtils.handlePiercingBeamCollision(world, caster, pos, endPos, borderSize, spellEntity, directDamage, damageType, damage, knockBack, invulnerable, fireTime, radius, lifeSteal, filter);
            }
        }
    }

    public static void handlePiercingBeamCollision(World world, EntityLivingBase caster, Vec3d startPos, Vec3d endPos, float borderSize, Entity spellEntity, DamageSource damageSource, float damage, Vec3d knockBack, boolean invulnerable, int fireTime, float radius, float lifeSteal, Predicate<? super Entity> filter) {
        RayTraceResult result = ArcaneUtils.standardEntityRayTrace(world, startPos, endPos, filter = filter.or(entity1 -> entity1 == caster || entity1 == spellEntity), false, borderSize, true, false);
        if (result != null && result.field_72308_g instanceof EntityLivingBase && result.field_72308_g != caster && result.field_72308_g != spellEntity) {
            EntityLivingBase hit = (EntityLivingBase)result.field_72308_g;
            hit.func_70015_d(fireTime);
            caster.func_70691_i(damage * lifeSteal);
            hit.func_70097_a(damageSource, damage);
            filter = filter.or(entity1 -> entity1 == hit);
            Vec3d kM = endPos.func_178788_d(startPos).func_186678_a(0.01);
            hit.field_70159_w += knockBack.field_72450_a * kM.field_72450_a;
            hit.field_70181_x += knockBack.field_72448_b * kM.field_72448_b;
            hit.field_70179_y += knockBack.field_72449_c * kM.field_72449_c;
            hit.func_184224_h(invulnerable);
            ArcaneUtils.applyPlayerKnockback((Entity)hit);
            Vec3d pos = result.field_72307_f;
            AxisAlignedBB hitBox = new AxisAlignedBB(pos.field_72450_a + (double)radius, pos.field_72448_b + (double)radius, pos.field_72449_c + (double)radius, pos.field_72450_a - (double)radius, pos.field_72448_b - (double)radius, pos.field_72449_c - (double)radius);
            List nearby = world.func_72872_a(EntityLivingBase.class, hitBox);
            nearby.removeIf(filter);
            if (!nearby.isEmpty()) {
                for (Entity e : nearby) {
                    if (e == caster || e == hit || e.func_96124_cp() == caster.func_96124_cp()) continue;
                    e.func_70015_d(fireTime);
                    e.func_70097_a(damageSource, damage);
                    e.field_70159_w += knockBack.field_72450_a;
                    e.field_70181_x += knockBack.field_72448_b;
                    e.field_70179_y += knockBack.field_72449_c;
                    ArcaneUtils.applyPlayerKnockback(e);
                    filter = filter.or(entity1 -> entity1 == e);
                }
            } else {
                ArcaneUtils.handlePiercingBeamCollision(world, caster, pos, endPos, borderSize, spellEntity, damageSource, damage, knockBack, invulnerable, fireTime, radius, lifeSteal, filter);
            }
        }
    }

    public static void handleBeamCollision(World world, EntityLivingBase caster, Vec3d startPos, Vec3d endPos, float borderSize, Entity spellEntity, boolean directDamage, MagicDamage.DamageType damageType, float damage, Vec3d knockBack, boolean invulnerable, int fireTime, float radius, float lifeSteal, Predicate<? super Entity> filter) {
        RayTraceResult result;
        filter = filter.or(e -> e == caster);
        if (spellEntity != null) {
            filter = filter.or(e -> e == spellEntity);
        }
        if ((result = ArcaneUtils.standardEntityRayTrace(world, startPos, endPos, filter, false, borderSize, true, false)) != null && result.field_72308_g instanceof EntityLivingBase && !filter.test(result.field_72308_g)) {
            EntityLivingBase hit = (EntityLivingBase)result.field_72308_g;
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)damageType, (Entity)hit)) {
                hit.func_70015_d(fireTime);
                caster.func_70691_i(damage * lifeSteal);
                if (directDamage) {
                    hit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)damageType), damage);
                } else if (spellEntity != null) {
                    hit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)spellEntity, (Entity)caster, (MagicDamage.DamageType)damageType), damage);
                }
                Vec3d kM = endPos.func_178788_d(startPos).func_186678_a(0.01);
                hit.field_70159_w += knockBack.field_72450_a * kM.field_72450_a;
                hit.field_70181_x += knockBack.field_72448_b * kM.field_72448_b;
                hit.field_70179_y += knockBack.field_72449_c * kM.field_72449_c;
                hit.func_184224_h(invulnerable);
                ArcaneUtils.applyPlayerKnockback((Entity)hit);
                filter = filter.or(e -> e == hit);
            }
            Vec3d pos = hit.func_174791_d().func_72441_c(0.0, (double)hit.func_70047_e(), 0.0);
            AxisAlignedBB hitBox = new AxisAlignedBB(pos.field_72450_a + (double)radius, pos.field_72448_b + (double)radius, pos.field_72449_c + (double)radius, pos.field_72450_a - (double)radius, pos.field_72448_b - (double)radius, pos.field_72449_c - (double)radius);
            List nearby = world.func_72872_a(EntityLivingBase.class, hitBox);
            nearby.removeIf(filter);
            if (!nearby.isEmpty()) {
                for (Entity secondHit : nearby) {
                    if (secondHit != caster && secondHit != hit && secondHit.func_96124_cp() != caster.func_96124_cp() && !MagicDamage.isEntityImmune((MagicDamage.DamageType)damageType, (Entity)secondHit)) {
                        secondHit.func_70015_d(fireTime);
                        if (directDamage) {
                            secondHit.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)damageType), damage);
                        } else if (spellEntity != null) {
                            secondHit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)spellEntity, (Entity)caster, (MagicDamage.DamageType)damageType), damage);
                        }
                        secondHit.field_70159_w += knockBack.field_72450_a;
                        secondHit.field_70181_x += knockBack.field_72448_b;
                        secondHit.field_70179_y += knockBack.field_72449_c;
                        ArcaneUtils.applyPlayerKnockback(secondHit);
                        filter = filter.or(e -> e == secondHit);
                    }
                    if (secondHit.func_96124_cp() != caster.func_96124_cp() || damageType != MagicDamage.DamageType.RADIANT || !(secondHit instanceof EntityLivingBase)) continue;
                    ((EntityLivingBase)secondHit).func_70691_i(damage);
                }
            }
        }
    }

    @Nullable
    public static RayTraceResult tracePath(World world, float x, float y, float z, float tx, float ty, float tz, float borderSize, HashSet<Entity> excluded, boolean collideablesOnly, boolean raytraceNonSolidBlocks) {
        Vec3d startVec = new Vec3d((double)x, (double)y, (double)z);
        Vec3d endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float minX = Math.min(x, tx);
        float minY = Math.min(y, ty);
        float minZ = Math.min(z, tz);
        float maxX = Math.max(x, tx);
        float maxY = Math.max(y, ty);
        float maxZ = Math.max(z, tz);
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        RayTraceResult blockHit = world.func_72933_a(startVec, endVec);
        if (blockHit != null && !world.func_180495_p(blockHit.func_178782_a()).func_185913_b() && !raytraceNonSolidBlocks) {
            blockHit = null;
        }
        startVec = new Vec3d((double)x, (double)y, (double)z);
        endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (blockHit != null) {
            maxDistance = (float)blockHit.field_72307_f.func_72438_d(startVec);
        }
        Entity closestHitEntity = null;
        float closestHit = maxDistance;
        for (Entity ent : allEntities) {
            float currentHit;
            RayTraceResult intercept;
            if (!ent.func_70067_L() && collideablesOnly || excluded != null && excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder);
            if (borderSize != 0.0f) {
                entityBb = entityBb.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            }
            if ((intercept = entityBb.func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            blockHit = new RayTraceResult(closestHitEntity);
        }
        return blockHit;
    }

    public static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static double getMagnitude(Vec3d vector) {
        return Math.sqrt(vector.field_72450_a * vector.field_72450_a + vector.field_72448_b * vector.field_72448_b + vector.field_72449_c * vector.field_72449_c);
    }

    public static boolean attemptGroundedTeleport(EntityLivingBase entity, double x, double y, double z) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        World world = entity.field_70170_p;
        BlockPos blockpos = new BlockPos((Entity)entity);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    public static boolean attemptDimensionalGroundedTeleport(EntityLivingBase entity, double x, double y, double z, int targetDimension) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y;
        entity.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)entity);
        World world = entity.field_70170_p;
        entity.func_184204_a(targetDimension);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    public static boolean attemptTeleport(EntityLivingBase entity, double x, double y, double z) {
        double d0 = entity.field_70165_t;
        double d1 = entity.func_174813_aQ().field_72338_b;
        double d2 = entity.field_70161_v;
        entity.field_70165_t = x;
        entity.field_70163_u = y - 1.0;
        entity.field_70161_v = z;
        boolean flag = false;
        World world = entity.field_70170_p;
        entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
            flag = true;
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    public static List<Entity> getEntitiesWithinRadius(double radius, double x, double y, double z, World world) {
        return EntityUtils.getEntitiesWithinRadius((double)radius, (double)x, (double)y, (double)z, (World)world, Entity.class);
    }

    public static SoundEvent createSound(String name) {
        return (SoundEvent)new SoundEvent(new ResourceLocation("arcane_essentials", name)).setRegistryName(name);
    }

    public static Entity getEntityFromStringID(World world, String UUID2) {
        return EntityUtils.getEntityByUUID((World)world, (UUID)UUID.fromString(UUID2));
    }

    public static EntityPlayer getPlayerFromStringID(String UUID2) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(UUID2));
    }

    public static EntityPlayer getPlayerFromUsername(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(username);
    }
}

