/*
 * Decompiled with CFR 0.152.
 */
package com.favouritedragon.arcaneessentials.common.util;

import com.favouritedragon.arcaneessentials.common.util.NBTInterfaceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static UUID readUUIDFromNBT(NBTTagCompound nbt, String key) {
        return new UUID(nbt.func_74763_f(key + "MostSig"), nbt.func_74763_f(key + "LeastSig"));
    }

    public static void writeUUIDToNBT(NBTTagCompound nbt, String key, UUID uuid) {
        nbt.func_74772_a(key + "MostSig", uuid.getMostSignificantBits());
        nbt.func_74772_a(key + "LeastSig", uuid.getLeastSignificantBits());
    }

    public static NBTTagCompound nestedCompound(NBTTagCompound nbt, String key) {
        if (nbt.func_74764_b(key)) {
            return nbt.func_74775_l(key);
        }
        NBTTagCompound result = new NBTTagCompound();
        nbt.func_74782_a(key, (NBTBase)result);
        return result;
    }

    public static <T> List<T> readListFromNBT(NBTTagCompound nbt, String key, NBTInterfaceUtils.CreateFromNBT<T> creator, Object ... extraData) {
        ArrayList<T> result = new ArrayList<T>();
        NBTTagList nbtList = nbt.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            result.add(creator.create(nbtList.func_150305_b(i), new Object[0], extraData));
        }
        return result;
    }

    public static <T> void writeListToNBT(NBTTagCompound nbt, String key, NBTInterfaceUtils.WriteToNBT<T> writer, List<T> list, Object ... extraData) {
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            NBTTagCompound comp = new NBTTagCompound();
            writer.write(comp, list.get(i), new Object[0], extraData);
            nbtList.func_74742_a((NBTBase)comp);
        }
        nbt.func_74782_a(key, (NBTBase)nbtList);
    }

    public static <K, V> Map<K, V> readMapFromNBT(NBTTagCompound nbt, NBTInterfaceUtils.MapUser<K, V> mapUser, String key, Object[] constructArgsK, Object[] constructArgsV) {
        HashMap<K, V> result = new HashMap<K, V>();
        NBTTagList nbtList = nbt.func_150295_c(key, 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtI = nbtList.func_150305_b(i);
            NBTTagCompound nbtK = nbtI.func_74775_l("Key");
            NBTTagCompound nbtV = nbtI.func_74775_l("Val");
            K k = mapUser.createK(nbtK, constructArgsK);
            V v = mapUser.createV(nbtV, k, constructArgsV);
            result.put(k, v);
        }
        return result;
    }

    public static <K, V> void writeMapToNBT(NBTTagCompound nbt, Map<K, V> map, NBTInterfaceUtils.MapUser<K, V> mapUser, String key) {
        NBTTagList nbtList = new NBTTagList();
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            NBTTagCompound nbtI = new NBTTagCompound();
            NBTTagCompound nbtK = new NBTTagCompound();
            NBTTagCompound nbtV = new NBTTagCompound();
            mapUser.writeK(nbtK, entry.getKey());
            mapUser.writeV(nbtV, entry.getValue());
            nbtI.func_74782_a("Key", (NBTBase)nbtK);
            nbtI.func_74782_a("Val", (NBTBase)nbtV);
            nbtList.func_74742_a((NBTBase)nbtI);
        }
        nbt.func_74782_a(key, (NBTBase)nbtList);
    }

    public static NBTTagCompound stackCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
            return nbt;
        }
        return stack.func_77978_p();
    }
}

