/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.proxy;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.ItemNBTUtils;
import java.util.HashSet;
import java.util.Set;
import morph.avaritia.api.registration.IModelRegister;
import morph.avaritia.client.AvaritiaClientEventHandler;
import morph.avaritia.client.render.entity.RenderGapingVoid;
import morph.avaritia.client.render.entity.RenderHeavenArrow;
import morph.avaritia.client.render.entity.WrappedEntityItemRenderer;
import morph.avaritia.client.render.shader.ShaderHelper;
import morph.avaritia.entity.EntityEndestPearl;
import morph.avaritia.entity.EntityGapingVoid;
import morph.avaritia.entity.EntityHeavenArrow;
import morph.avaritia.entity.EntityHeavenSubArrow;
import morph.avaritia.init.AvaritiaTextures;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.ItemMatterCluster;
import morph.avaritia.network.ClientPacketHandler;
import morph.avaritia.proxy.Proxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ProxyClient
extends Proxy {
    private Set<IModelRegister> modelRegisters = new HashSet<IModelRegister>();
    public static final int[] SINGULARITY_COLOURS_FOREGROUND = new int[]{15132648, 15265571, 5931746, 0xDF0000, 0xFFFFFF, 14971392, 10864606, 4472946, 0xC0C0C0, 14606727, 4566181, 6078004, 14033670, 49151, 15132410};
    public static final int[] SINGULARITY_COLOURS_BACKGROUND = new int[]{0x7F7F7F, 14393875, 2247599, 0x900000, 9733757, 8999194, 10201522, 4078926, 0xD5D5D5, 12895896, 9424329, 9228656, 16776341, 5931746, 15132410};
    public static final int[][] SINGULARITY_COLOURS = new int[][]{SINGULARITY_COLOURS_FOREGROUND, SINGULARITY_COLOURS_BACKGROUND};

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        TextureUtils.addIconRegister((TextureUtils.IIconRegister)new AvaritiaTextures());
        MinecraftForge.EVENT_BUS.register((Object)new AvaritiaClientEventHandler());
        for (IModelRegister register : this.modelRegisters) {
            register.registerModels();
        }
        ShaderHelper.initShaders();
        ResourceLocation tools = new ResourceLocation("avaritia:tools");
        ResourceLocation resource = new ResourceLocation("avaritia:resource");
        ModelResourceLocation pickaxe = new ModelResourceLocation(tools, "infinity_pickaxe=pickaxe");
        ModelResourceLocation hammer = new ModelResourceLocation(tools, "infinity_pickaxe=hammer");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_pickaxe, (ResourceLocation[])new ResourceLocation[]{pickaxe, hammer});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_pickaxe, stack -> {
            if (stack.func_77942_o() && ItemNBTUtils.getBoolean((ItemStack)stack, (String)"hammer")) {
                return hammer;
            }
            return pickaxe;
        });
        ModelResourceLocation shovel = new ModelResourceLocation(tools, "infinity_shovel=shovel");
        ModelResourceLocation destroyer = new ModelResourceLocation(tools, "infinity_shovel=destroyer");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_shovel, (ResourceLocation[])new ResourceLocation[]{shovel, destroyer});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_shovel, stack -> {
            if (stack.func_77942_o() && ItemNBTUtils.getBoolean((ItemStack)stack, (String)"destroyer")) {
                return destroyer;
            }
            return shovel;
        });
        ModelResourceLocation axe = new ModelResourceLocation(tools, "type=infinity_axe");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_axe, (ResourceLocation[])new ResourceLocation[]{axe});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_axe, stack -> axe);
        ModelResourceLocation hoe = new ModelResourceLocation(tools, "type=infinity_hoe");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_axe, (ResourceLocation[])new ResourceLocation[]{hoe});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_hoe, stack -> hoe);
        ModelResourceLocation helmet = new ModelResourceLocation(tools, "armor=helmet");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_helmet, (ResourceLocation[])new ResourceLocation[]{helmet});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_helmet, stack -> helmet);
        ModelResourceLocation chestplate = new ModelResourceLocation(tools, "armor=chestplate");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_chestplate, (ResourceLocation[])new ResourceLocation[]{chestplate});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_chestplate, stack -> chestplate);
        ModelResourceLocation legs = new ModelResourceLocation(tools, "armor=legs");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_pants, (ResourceLocation[])new ResourceLocation[]{legs});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_pants, stack -> legs);
        ModelResourceLocation boots = new ModelResourceLocation(tools, "armor=boots");
        ModelLoader.registerItemVariants((Item)ModItems.infinity_boots, (ResourceLocation[])new ResourceLocation[]{boots});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.infinity_boots, stack -> boots);
        ModelResourceLocation sword = new ModelResourceLocation(tools, "type=skull_sword");
        ModelLoader.registerItemVariants((Item)ModItems.skull_sword, (ResourceLocation[])new ResourceLocation[]{sword});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.skull_sword, stack -> sword);
        ModelResourceLocation stew = new ModelResourceLocation(resource, "type=ultimate_stew");
        ModelLoader.registerItemVariants((Item)ModItems.ultimate_stew, (ResourceLocation[])new ResourceLocation[]{stew});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.ultimate_stew, stack -> stew);
        ModelResourceLocation meatballs = new ModelResourceLocation(resource, "type=cosmic_meatballs");
        ModelLoader.registerItemVariants((Item)ModItems.cosmic_meatballs, (ResourceLocation[])new ResourceLocation[]{meatballs});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.cosmic_meatballs, stack -> meatballs);
        ModelResourceLocation empty = new ModelResourceLocation(resource, "matter_cluster=empty");
        ModelResourceLocation full = new ModelResourceLocation(resource, "matter_cluster=full");
        ModelLoader.registerItemVariants((Item)ModItems.matter_cluster, (ResourceLocation[])new ResourceLocation[]{empty, full});
        ModelLoader.setCustomMeshDefinition((Item)ModItems.matter_cluster, stack -> {
            if (ItemMatterCluster.getClusterSize(stack) == ItemMatterCluster.CAPACITY) {
                return full;
            }
            return empty;
        });
        this.registerRenderers();
        PacketCustom.assignHandler((Object)"avaritia", (ICustomPacketHandler)new ClientPacketHandler());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_186730_a((stack, tintIndex) -> SINGULARITY_COLOURS[tintIndex ^ 1][stack.func_77952_i()], new Item[]{ModItems.singularity});
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Render render = (Render)manager.field_78729_o.get(EntityItem.class);
        if (render == null) {
            throw new RuntimeException("EntityItem does not have a Render bound... This is likely a bug..");
        }
        manager.field_78729_o.put(EntityItem.class, new WrappedEntityItemRenderer(manager, (Render<EntityItem>)render));
    }

    @Override
    public void addModelRegister(IModelRegister register) {
        this.modelRegisters.add(register);
    }

    private void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityEndestPearl.class, manager -> new RenderSnowball(manager, (Item)ModItems.endest_pearl, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityGapingVoid.class, RenderGapingVoid::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHeavenArrow.class, RenderHeavenArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHeavenSubArrow.class, RenderHeavenArrow::new);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

