/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.chest.infinity;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.avaritiaddons.block.chest.infinity.TileEntityInfinityChest;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.NbtMatcher;

public final class InfinityMatching
extends AbstractMatching<InfinityMatching> {
    private static final int LAST_BIT = Integer.MIN_VALUE;
    private final TileEntityInfinityChest tileEntityInfinityChest;
    private ItemStack stack = ItemStack.field_190927_a;
    private int count = 0;

    public InfinityMatching(@Nonnull TileEntityInfinityChest tileEntityInfinityChest, int number) {
        this(tileEntityInfinityChest, number, null);
    }

    public InfinityMatching(@Nonnull TileEntityInfinityChest tileEntityInfinityChest, int number, NBTTagCompound tagToRead) {
        super(null, number, tagToRead);
        this.tileEntityInfinityChest = tileEntityInfinityChest;
        this.setNbtMatcher();
    }

    @Nonnull
    public TileEntityInfinityChest getTileEntityInfinityChest() {
        return this.tileEntityInfinityChest;
    }

    public void insert(@Nonnull ItemStack stack) {
        if (this.matches(stack)) {
            if (((this.count += stack.func_190916_E()) & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                this.count = Integer.MAX_VALUE;
            }
        } else if (this.isEmpty()) {
            this.count = stack.func_190916_E();
            this.stack = stack.func_77946_l();
            this.stack.func_190920_e(1);
        }
        this.setNbtMatcher();
        this.markTileDirty();
    }

    @Nonnull
    public ItemStack extract(int amount, boolean simulate) {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = this.stack.func_77946_l();
        int remaining = this.count - (amount = MathHelper.func_76125_a((int)amount, (int)1, (int)newStack.func_77976_d()));
        if (remaining < 0) {
            amount += remaining;
        }
        newStack.func_190920_e(amount);
        if (!simulate) {
            this.count -= amount;
            if (this.count == 0) {
                this.setEmpty();
            }
        }
        this.markTileDirty();
        return newStack;
    }

    public boolean isEmpty() {
        return this.count == 0 || super.isEmpty();
    }

    public ItemStack getStack() {
        if (this.count == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = this.stack.func_77946_l();
        newStack.func_190920_e(this.count);
        return newStack;
    }

    public int getMaxStackSize() {
        return this.stack.func_77976_d();
    }

    public ItemStack getActualStack() {
        return this.stack;
    }

    private void setEmpty() {
        this.setStack(ItemStack.field_190927_a, 0);
        this.validate();
    }

    private void setStack(@Nonnull ItemStack stack, int count) {
        this.stack = stack;
        this.count = count;
        this.setNbtMatcher();
    }

    private void setNbtMatcher() {
        this.setMatcher((AbstractMatcher)new NbtMatcher((AbstractMatching)this));
    }

    public int getCount() {
        return this.count;
    }

    private void markTileDirty() {
        this.tileEntityInfinityChest.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public String getSimplifiedCount() {
        if (this.count > 0 && this.count < 1000) {
            return Integer.toString(this.count);
        }
        if (this.count >= 1000 && this.count < 1000000) {
            return this.count / 1000 + "K";
        }
        if ((long)this.count >= 1000000L && this.count < 1000000000) {
            return this.count / 1000000 + "M";
        }
        if (this.count >= 1000000000) {
            return this.count / 1000000000 + "B";
        }
        return Integer.toString(this.count);
    }

    public void customWriteNBT(@Nonnull NBTTagCompound nbtToWrite) {
        this.stack.func_77955_b(nbtToWrite);
        nbtToWrite.func_74768_a("count", this.count);
    }

    public void customReadNBT(@Nonnull NBTTagCompound nbtToRead) {
        this.setStack(new ItemStack(nbtToRead), nbtToRead.func_74762_e("count"));
    }

    @Nonnull
    public InfinityMatching copy() {
        return new InfinityMatching(this.tileEntityInfinityChest, this.number, this.writeNBT());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InfinityMatching) {
            InfinityMatching infinityMatching = (InfinityMatching)((Object)obj);
            return infinityMatching.number == this.number && this.matcher.equals(infinityMatching.matcher) && this.matches(infinityMatching.stack) && this.count == infinityMatching.count;
        }
        return false;
    }
}

