/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.extremeautocrafter;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import wanion.avaritiaddons.block.extremeautocrafter.TileEntityExtremeAutoCrafter;
import wanion.lib.common.IGhostAcceptorContainer;
import wanion.lib.common.IResourceShapedContainer;
import wanion.lib.common.Util;
import wanion.lib.common.WContainer;
import wanion.lib.common.WTileEntity;
import wanion.lib.inventory.slot.ShapeSlot;
import wanion.lib.inventory.slot.SpecialSlot;

public final class ContainerExtremeAutoCrafter
extends WContainer<TileEntityExtremeAutoCrafter>
implements IResourceShapedContainer,
IGhostAcceptorContainer {
    private final TileEntityExtremeAutoCrafter tileEntityExtremeAutoCrafter;
    private final int playerInventoryEnds;
    private final int playerInventoryStarts;
    private final int inventoryFull;
    private final int result;

    public ContainerExtremeAutoCrafter(@Nonnull TileEntityExtremeAutoCrafter tileEntityExtremeAutoCrafter, InventoryPlayer inventoryPlayer) {
        super((WTileEntity)tileEntityExtremeAutoCrafter);
        int inventorySize;
        int x;
        int y;
        this.tileEntityExtremeAutoCrafter = tileEntityExtremeAutoCrafter;
        ArrayList<Object> slotList = new ArrayList<Object>();
        for (y = 0; y < 9; ++y) {
            for (x = 0; x < 9; ++x) {
                slotList.add(new Slot((IInventory)tileEntityExtremeAutoCrafter, y * 9 + x, 8 + 18 * x, 18 + 18 * y));
            }
        }
        for (y = 0; y < 9; ++y) {
            for (x = 0; x < 9; ++x) {
                slotList.add(new ShapeSlot((IInventory)tileEntityExtremeAutoCrafter, 81 + (y * 9 + x), 175 + 18 * x, 18 + 18 * y));
            }
        }
        slotList.add(new SpecialSlot((IInventory)tileEntityExtremeAutoCrafter, 162, 247, 222));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                slotList.add(new Slot((IInventory)inventoryPlayer, 9 + y * 9 + x, 43 + 18 * x, 194 + 18 * y));
            }
        }
        for (int i = 0; i < 9; ++i) {
            slotList.add(new Slot((IInventory)inventoryPlayer, i, 43 + 18 * i, 252));
        }
        slotList.forEach(arg_0 -> ((ContainerExtremeAutoCrafter)this).func_75146_a(arg_0));
        this.playerInventoryEnds = inventorySize = this.field_75151_b.size();
        this.playerInventoryStarts = inventorySize - 36;
        this.inventoryFull = (this.playerInventoryStarts - 1) / 2;
        this.result = this.inventoryFull * 2;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slot) {
        ItemStack itemstack = null;
        Slot actualSlot = (Slot)this.field_75151_b.get(slot);
        if (actualSlot != null && actualSlot.func_75216_d()) {
            ItemStack itemstack1 = actualSlot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slot >= this.playerInventoryStarts ? !this.func_75135_a(itemstack1, 0, this.inventoryFull, false) : (slot <= this.inventoryFull || slot == this.result) && !this.func_75135_a(itemstack1, this.playerInventoryStarts, this.playerInventoryEnds, true)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            }
            actualSlot.func_75218_e();
        }
        return itemstack != null ? itemstack : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int mouseButton, @Nonnull ClickType clickType, @Nonnull EntityPlayer entityPlayer) {
        if (slot >= this.inventoryFull && slot < this.result) {
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            if (clickType == ClickType.QUICK_MOVE) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            } else if (clickType == ClickType.PICKUP) {
                ItemStack playerStack = entityPlayer.field_71071_by.func_70445_o();
                boolean slotHasStack = actualSlot.func_75216_d();
                if (!playerStack.func_190926_b() && !slotHasStack) {
                    ItemStack newSlotStack = playerStack.func_77946_l();
                    newSlotStack.func_190920_e(1);
                    actualSlot.func_75215_d(newSlotStack);
                } else if (playerStack.func_190926_b() && slotHasStack || !playerStack.func_190926_b() && playerStack.func_77969_a(actualSlot.func_75211_c())) {
                    actualSlot.func_75215_d(ItemStack.field_190927_a);
                }
            }
            this.tileEntityExtremeAutoCrafter.recipeShapeChanged();
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, mouseButton, clickType, entityPlayer);
    }

    public void defineShape(@Nonnull ResourceLocation resourceLocation) {
        IExtremeRecipe extremeRecipe = (IExtremeRecipe)AvaritiaRecipeManager.EXTREME_RECIPES.get(resourceLocation);
        if (extremeRecipe == null) {
            return;
        }
        int startsIn = this.inventoryFull;
        int endsIn = this.result;
        int root = (int)Math.sqrt(endsIn - startsIn);
        this.clearShape(startsIn, endsIn);
        NonNullList inputs = extremeRecipe.getIngredients();
        if (extremeRecipe.isShapedRecipe()) {
            int i = 0;
            for (int y = 0; y < root; ++y) {
                for (int x = 0; x < root; ++x) {
                    ItemStack stackInput;
                    if (i >= inputs.size() || x >= extremeRecipe.getWidth() || y >= extremeRecipe.getHeight()) continue;
                    Slot slot = (Slot)this.field_75151_b.get(startsIn + (x + root * y));
                    if ((stackInput = Util.getStackFromIngredient((Ingredient)((Ingredient)inputs.get(i++)))) == null) continue;
                    slot.func_75215_d(stackInput);
                }
            }
        } else {
            for (int i = 0; i < inputs.size() && i < root * root; ++i) {
                Slot slot = (Slot)this.field_75151_b.get(startsIn + i);
                ItemStack stackInput = Util.getStackFromIngredient((Ingredient)((Ingredient)inputs.get(i)));
                if (stackInput == null) continue;
                slot.func_75215_d(stackInput);
            }
        }
        this.tileEntityExtremeAutoCrafter.recipeShapeChanged();
        this.func_75142_b();
    }

    public void clearShape() {
        int slotCount = this.field_75151_b.size();
        int startsIn = (slotCount - 36) / 2 - 1;
        int endsIn = slotCount - 37;
        this.clearShape(startsIn, endsIn);
        this.tileEntityExtremeAutoCrafter.recipeShapeChanged();
    }

    private void clearShape(int startsIn, int endsIn) {
        for (int i = startsIn; i < endsIn; ++i) {
            ((Slot)this.field_75151_b.get(i)).func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void acceptGhostStack(int slot, @Nonnull ItemStack itemStack) {
        if (slot >= this.inventoryFull && slot < this.result) {
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            if (itemStack.func_77969_a(actualSlot.func_75211_c())) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                actualSlot.func_75215_d(itemStack);
            }
            this.tileEntityExtremeAutoCrafter.recipeShapeChanged();
            this.func_75142_b();
        }
    }
}

