/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.infinitycompressor;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import morph.avaritia.entity.EntityImmortalItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import wanion.avaritiaddons.Avaritiaddons;
import wanion.avaritiaddons.Reference;
import wanion.avaritiaddons.block.infinitycompressor.TileEntityInfinityCompressor;
import wanion.lib.common.WrenchHelper;

public class BlockInfinityCompressor
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final BlockInfinityCompressor INSTANCE = new BlockInfinityCompressor();

    protected BlockInfinityCompressor() {
        super(Material.field_151573_f);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.setHarvestLevel("pickaxe", 3);
        this.func_149663_c("infinity_compressor");
        this.func_149647_a(Avaritiaddons.creativeTabs);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setRegistryName(new ResourceLocation("avaritiaddons", "infinity_compressor"));
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityInfinityCompressor();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return 15;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack itemStack) {
        NBTTagCompound stackNBT;
        if (world == null) {
            return;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d()), 3);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityInfinityCompressor && (stackNBT = itemStack.func_77978_p()) != null) {
            ((TileEntityInfinityCompressor)tileEntity).readCustomNBT(itemStack.func_77978_p());
        }
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState blockState, @Nonnull Random random, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!(world.field_72995_K || entityPlayer.func_70093_af() || WrenchHelper.INSTANCE.isWrench(entityPlayer.func_184586_b(hand)))) {
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (tileEntity instanceof TileEntityInfinityCompressor) {
                FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)Avaritiaddons.instance, (int)3, (World)world, (int)blockPos.func_177958_n(), (int)blockPos.func_177956_o(), (int)blockPos.func_177952_p());
            } else {
                return false;
            }
        }
        return true;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (world == null) {
            return;
        }
        TileEntityInfinityCompressor tileEntityInfinityCompressor = (TileEntityInfinityCompressor)world.func_175625_s(blockPos);
        if (tileEntityInfinityCompressor != null) {
            ItemStack droppedStack = new ItemStack((Block)this, 1, 0);
            NBTTagCompound nbtTagCompound = tileEntityInfinityCompressor.writeCustomNBT(new NBTTagCompound());
            if (!nbtTagCompound.func_82582_d()) {
                droppedStack.func_77982_d(nbtTagCompound);
            }
            world.func_72838_d((Entity)new EntityImmortalItem(world, (double)((float)blockPos.func_177958_n() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), (double)((float)blockPos.func_177956_o() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), (double)((float)blockPos.func_177952_p() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), droppedStack));
        }
        super.func_180663_b(world, blockPos, blockState);
    }
}

