/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.infinitycompressor;

import javax.annotation.Nonnull;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.compressor.ICompressorRecipe;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import wanion.avaritiaddons.block.infinitycompressor.TileEntityInfinityCompressor;
import wanion.lib.common.field.IField;

public class CompressorRecipeField
implements IField<CompressorRecipeField> {
    private final TileEntityInfinityCompressor tileEntityInfinityCompressor;
    private ICompressorRecipe compressorRecipe;
    private int progress;

    public CompressorRecipeField(@Nonnull TileEntityInfinityCompressor tileEntityInfinityCompressor) {
        this.tileEntityInfinityCompressor = tileEntityInfinityCompressor;
    }

    @Nonnull
    public String getFieldName() {
        return "compressor.recipe.field";
    }

    public void addProgress(int progressToAdd) {
        int compressionCost = this.compressorRecipe.getCost();
        this.progress += progressToAdd;
        int dif = this.progress - compressionCost;
        this.progress = MathHelper.func_76125_a((int)this.progress, (int)0, (int)compressionCost);
        if (dif >= 0) {
            this.progress = dif;
            ItemStack outputStack = this.tileEntityInfinityCompressor.func_70301_a(0);
            ItemStack recipeResult = this.compressorRecipe.getResult();
            if (outputStack.func_190926_b()) {
                this.tileEntityInfinityCompressor.func_70299_a(0, recipeResult.func_77946_l());
            } else {
                outputStack.func_190920_e(outputStack.func_190916_E() + recipeResult.func_190916_E());
            }
            if (this.progress == 0) {
                this.setCompressorRecipe(null);
            }
        }
    }

    public String getProgress() {
        return this.compressorRecipe != null ? this.progress + " / " + this.compressorRecipe.getCost() : I18n.func_135052_a((String)"avaritiaddons.compressor.no.recipe.set", (Object[])new Object[0]);
    }

    public boolean isNull() {
        return this.compressorRecipe == null;
    }

    public void setCompressorRecipe(ICompressorRecipe compressorRecipe) {
        this.compressorRecipe = compressorRecipe;
        this.progress = 0;
    }

    public ICompressorRecipe getCompressorRecipe() {
        return this.compressorRecipe;
    }

    public ItemStack getCompressorRecipeOutput() {
        return this.compressorRecipe != null ? this.compressorRecipe.getResult().func_77946_l() : ItemStack.field_190927_a;
    }

    public boolean matches(@Nonnull ItemStack stack) {
        return this.compressorRecipe != null && this.compressorRecipe.matches(stack);
    }

    @Nonnull
    public CompressorRecipeField copy() {
        CompressorRecipeField extremeRecipeField = new CompressorRecipeField(this.tileEntityInfinityCompressor);
        extremeRecipeField.readNBT(this.writeNBT());
        return extremeRecipeField;
    }

    public void receiveNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.readNBT(nbtTagCompound);
    }

    @Nonnull
    public NBTTagCompound writeNBT() {
        ResourceLocation resourceLocation;
        NBTTagCompound tag = super.writeNBT();
        tag.func_74778_a("fieldName", this.getFieldName());
        if (this.compressorRecipe != null && (resourceLocation = this.compressorRecipe.getRegistryName()) != null) {
            tag.func_74778_a("compressor.recipe", resourceLocation.toString());
            tag.func_74768_a("compressor.recipe.progress", this.progress);
        }
        return tag;
    }

    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.compressorRecipe = nbtTagCompound.func_74764_b("compressor.recipe") ? (ICompressorRecipe)AvaritiaRecipeManager.COMPRESSOR_RECIPES.get(new ResourceLocation(nbtTagCompound.func_74779_i("compressor.recipe"))) : null;
        this.progress = nbtTagCompound.func_74762_e("compressor.recipe.progress");
    }

    public boolean equals(Object obj) {
        return obj instanceof CompressorRecipeField && ((CompressorRecipeField)obj).compressorRecipe == this.compressorRecipe && ((CompressorRecipeField)obj).progress == this.progress;
    }
}

