/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.baubles;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.brandon3055.brandonscore.lib.EnergyContainerWrapper;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.items.baubles.BasicBauble;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyBauble
extends BasicBauble
implements IEnergyContainerItem {
    protected int getCapacity(ItemStack stack) {
        return 0;
    }

    protected int getMaxReceive(ItemStack stack) {
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ItemStack stack) {
        return ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return this.getCapacity(stack);
    }

    public void modifyEnergy(ItemStack stack, int modify) {
        int energy = ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0);
        if ((energy += modify) > this.getCapacity(stack)) {
            energy = this.getCapacity(stack);
        } else if (energy < 0) {
            energy = 0;
        }
        ItemNBTHelper.setInteger((ItemStack)stack, (String)"Energy", (int)energy);
    }

    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        int energy = ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0);
        int energyReceived = Math.min(this.getCapacity(stack) - energy, Math.min(this.getMaxReceive(stack), maxReceive));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)stack, (String)"Energy", (int)(energy += energyReceived));
        }
        return energyReceived;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.getMaxEnergyStored(stack) > 0) {
            return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
        }
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        if (this.getMaxEnergyStored(stack) > 0) {
            InfoHelper.addEnergyInfo((ItemStack)stack, tooltip);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerWrapper(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"Equipped", (boolean)false) && this.getEnergyStored(stack) > 0;
    }

    @Override
    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"Equipped", (boolean)true);
        super.onEquipped(stack, player);
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"Equipped", (boolean)false);
        super.onUnequipped(stack, player);
    }
}

