/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.draconicevolution.api.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class ENetFXHandlerServer
extends ENetFXHandler<IENetEffectTile> {
    private CrystalUpdateBatcher.BatchedCrystalUpdate batchedUpdate;
    private Map<Byte, Byte> lastTickIndexToFlow = new HashMap<Byte, Byte>();
    private int lastTickEnergy = -1;

    public ENetFXHandlerServer(IENetEffectTile tile) {
        super(tile);
    }

    @Override
    public void update() {
    }

    @Override
    public void detectAndSendChanges() {
        this.lastTickIndexToFlow.clear();
        CrystalUpdateBatcher.BatchedCrystalUpdate update = new CrystalUpdateBatcher.BatchedCrystalUpdate(this.tile.getIDHash(), this.tile.getEnergyStored());
        for (byte i = 0; i < this.tile.getFlowRates().size(); i = (byte)(i + 1)) {
            byte flow = this.tile.getFlowRates().get(i);
            if (this.lastTickIndexToFlow.containsKey(i) && this.lastTickIndexToFlow.get(i) == flow) continue;
            update.indexToFlowMap.put(i, flow);
            this.lastTickIndexToFlow.put(i, flow);
        }
        if (update.indexToFlowMap.size() > 0 || Math.abs(this.lastTickEnergy - this.tile.getEnergyStored()) > 100) {
            this.lastTickEnergy = this.tile.getEnergyStored();
            this.batchedUpdate = update;
        }
        if (this.batchedUpdate != null) {
            this.sendUpdate();
        }
    }

    @Override
    public void reloadConnections() {
        this.lastTickIndexToFlow.clear();
    }

    private void sendUpdate() {
        WorldServer worldServer = (WorldServer)((TileEntity)this.tile).func_145831_w();
        PlayerChunkMapEntry playerChunkMap = worldServer.func_184164_w().func_187301_b(((TileEntity)this.tile).func_174877_v().func_177958_n() >> 4, ((TileEntity)this.tile).func_174877_v().func_177952_p() >> 4);
        if (playerChunkMap != null) {
            playerChunkMap.field_187283_c.forEach(playerMP -> CrystalUpdateBatcher.queData(this.batchedUpdate, playerMP));
        }
        this.batchedUpdate = null;
    }
}

