/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityDragonOld
extends EntityLiving
implements IEntityMultiPart,
IMob {
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public MultiPartEntityPart[] dragonPartArray;
    public MultiPartEntityPart dragonPartHead = new MultiPartEntityPart((IEntityMultiPart)this, "head", 6.0f, 6.0f);
    public MultiPartEntityPart dragonPartBody = new MultiPartEntityPart((IEntityMultiPart)this, "body", 8.0f, 8.0f);
    public MultiPartEntityPart dragonPartTail1 = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
    public MultiPartEntityPart dragonPartTail2 = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
    public MultiPartEntityPart dragonPartTail3 = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
    public MultiPartEntityPart dragonPartWing1 = new MultiPartEntityPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
    public MultiPartEntityPart dragonPartWing2 = new MultiPartEntityPart((IEntityMultiPart)this, "wing", 4.0f, 4.0f);
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    public boolean slowed;
    private Entity target;
    public int deathTicks;
    public EntityEnderCrystal healingEnderCrystal;

    public EntityDragonOld(World p_i1700_1_) {
        super(p_i1700_1_);
        this.dragonPartArray = new MultiPartEntityPart[]{this.dragonPartHead, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(16.0f, 8.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.targetY = 100.0;
        this.field_70158_ak = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double[] getMovementOffsets(int p_70974_1_, float p_70974_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int j = this.ringBufferIndex - p_70974_1_ * 1 & 0x3F;
        int k = this.ringBufferIndex - p_70974_1_ * 1 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[j][0];
        double d1 = MathHelper.func_76138_g((double)(this.ringBuffer[k][0] - d0));
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.ringBuffer[j][1];
        d1 = this.ringBuffer[k][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = this.ringBuffer[j][2] + (this.ringBuffer[k][2] - this.ringBuffer[j][2]) * (double)p_70974_2_;
        return adouble;
    }

    public void func_70636_d() {
    }

    private void updateDragonEnderCrystal() {
        if (this.healingEnderCrystal != null) {
            if (this.healingEnderCrystal.field_70128_L) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70965_a(this.dragonPartHead, DamageSource.func_94539_a((Explosion)null), 10.0f);
                }
                this.healingEnderCrystal = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            float f = 32.0f;
            List list = this.field_70170_p.func_72872_a(EntityEnderCrystal.class, this.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.func_70068_e((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.healingEnderCrystal = entityendercrystal;
        }
    }

    private void collideWithEntities(List p_70970_1_) {
        double d0 = (this.dragonPartBody.func_174813_aQ().field_72340_a + this.dragonPartBody.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.dragonPartBody.func_174813_aQ().field_72339_c + this.dragonPartBody.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double d2 = entity.field_70165_t - d0;
            double d3 = entity.field_70161_v - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
        }
    }

    private void attackEntitiesInList(List p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = (Entity)p_70971_1_.get(i);
            if (!(entity instanceof EntityLivingBase)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.field_70146_Z.nextInt(2) == 0 && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.target = (Entity)this.field_70170_p.field_73010_i.get(this.field_70146_Z.nextInt(this.field_70170_p.field_73010_i.size()));
        } else {
            double d2;
            double d1;
            double d0;
            boolean flag = false;
            do {
                this.targetX = 0.0;
                this.targetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 100.0));
            this.target = null;
        }
    }

    private float simplifyAngle(double p_70973_1_) {
        return (float)MathHelper.func_76138_g((double)p_70973_1_);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (this.field_70170_p.func_175623_d(pos)) continue;
                    if (state.func_177230_c().canEntityDestroy(state, (IBlockAccess)this.field_70170_p, pos, (Entity)this) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_175698_g(pos) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = p_70972_1_.field_72340_a + (p_70972_1_.field_72336_d - p_70972_1_.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = p_70972_1_.field_72338_b + (p_70972_1_.field_72337_e - p_70972_1_.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = p_70972_1_.field_72339_c + (p_70972_1_.field_72334_f - p_70972_1_.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart p_70965_1_, DamageSource p_70965_2_, float p_70965_3_) {
        if (p_70965_1_ != this.dragonPartHead) {
            p_70965_3_ = p_70965_3_ / 4.0f + 1.0f;
        }
        float f1 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f2 = MathHelper.func_76126_a((float)f1);
        float f3 = MathHelper.func_76134_b((float)f1);
        this.targetX = this.field_70165_t + (double)(f2 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.targetY = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.0f) + 1.0;
        this.targetZ = this.field_70161_v - (double)(f3 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.target = null;
        if (p_70965_2_.func_76346_g() instanceof EntityPlayer || p_70965_2_.func_94541_c()) {
            this.func_70097_a(p_70965_2_, p_70965_3_);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 1000; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                this.field_70170_p.func_175669_a(1018, new BlockPos((Entity)this), 0);
            }
        }
        this.func_70091_d(MoverType.SELF, 0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 2000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.createEnderPortal(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            this.func_70106_y();
        }
    }

    private void createEnderPortal(int p_70975_1_, int p_70975_2_) {
    }

    protected void func_70623_bb() {
    }

    public Entity[] func_70021_al() {
        return this.dragonPartArray;
    }

    public boolean func_70067_L() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }
}

