/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import electroblob.wizardry.worldgen.WorldGenWizardryStructure;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class StructureTrigger
implements ICriterionTrigger<Instance> {
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public StructureTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements advancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(advancements);
        if (listeners == null) {
            listeners = new Listeners(advancements);
            this.listeners.put(advancements, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements advancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(advancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(advancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements advancements) {
        this.listeners.remove(advancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        return new Instance(this.id, JsonUtils.func_151200_h((JsonObject)json, (String)"structure_type"));
    }

    public void trigger(EntityPlayerMP player) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(player.func_71121_q(), player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(WorldServer world, double x, double y, double z) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(world, x, y, z)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final WorldGenWizardryStructure structureType;

        public Instance(ResourceLocation criterionIn, String name) {
            super(criterionIn);
            this.structureType = WorldGenWizardryStructure.byName(name);
        }

        public boolean test(WorldServer world, double x, double y, double z) {
            return this.structureType.isInsideStructure((World)world, x, y, z);
        }
    }
}

