/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.block;

import com.google.common.collect.Maps;
import electroblob.wizardry.block.BlockImbuementAltar;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemSpectralDust;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.tileentity.TileEntityReceptacle;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReceptacle
extends BlockTorch
implements ITileEntityProvider {
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    protected static final AxisAlignedBB NORTH_WALL_AABB = new AxisAlignedBB(0.25, 0.125, 0.4375, 0.75, 0.625, 1.0);
    protected static final AxisAlignedBB SOUTH_WALL_AABB = new AxisAlignedBB(0.25, 0.125, 0.0, 0.75, 0.625, 0.5625);
    protected static final AxisAlignedBB WEST_WALL_AABB = new AxisAlignedBB(0.4375, 0.125, 0.25, 1.0, 0.625, 0.75);
    protected static final AxisAlignedBB EAST_WALL_AABB = new AxisAlignedBB(0.0, 0.125, 0.25, 0.5625, 0.625, 0.75);
    private static final double WALL_PARTICLE_OFFSET = 0.1875;
    public static final Map<Element, int[]> PARTICLE_COLOURS;

    public BlockReceptacle() {
        this.func_149647_a(WizardryTabs.WIZARDRY);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.5f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176596_a)) {
            case EAST: {
                return EAST_WALL_AABB;
            }
            case WEST: {
                return WEST_WALL_AABB;
            }
            case SOUTH: {
                return SOUTH_WALL_AABB;
            }
            case NORTH: {
                return NORTH_WALL_AABB;
            }
        }
        return STANDING_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185900_c(world, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReceptacle && ((TileEntityReceptacle)tileEntity).getElement() != null) {
            return super.getLightValue(state, world, pos);
        }
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Element element;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReceptacle && (element = ((TileEntityReceptacle)tileEntity).getElement()) != null) {
            drops.add((Object)new ItemStack(WizardryItems.spectral_dust, 1, element.ordinal()));
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && world.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_177230_c() instanceof BlockImbuementAltar) {
            return true;
        }
        return super.func_176198_a(world, pos, side);
    }

    protected boolean func_176593_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(world, pos, (EnumFacing)state.func_177229_b((IProperty)field_176596_a))) {
            return true;
        }
        return super.func_176593_f(world, pos, state);
    }

    protected boolean func_176592_e(World world, BlockPos pos, IBlockState state) {
        return !this.func_176593_f(world, pos, state);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_176596_a, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(world, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)field_176596_a, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState state = world.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        BlockFaceShape blockfaceshape = state.func_193401_d((IBlockAccess)world, blockpos, facing);
        if (facing.equals((Object)EnumFacing.UP) && this.canPlaceOn(world, blockpos)) {
            return true;
        }
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !BlockReceptacle.func_193382_c((Block)block) && (blockfaceshape == BlockFaceShape.SOLID || block instanceof BlockImbuementAltar);
        }
        return false;
    }

    private boolean canPlaceOn(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (tileEntity instanceof TileEntityReceptacle) {
            Element currentElement = ((TileEntityReceptacle)tileEntity).getElement();
            if (currentElement == null) {
                if (stack.func_77973_b() instanceof ItemSpectralDust && stack.func_77960_j() >= 0 && stack.func_77960_j() < Element.values().length) {
                    ((TileEntityReceptacle)tileEntity).setElement(Element.values()[stack.func_77960_j()]);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), WizardrySounds.BLOCK_RECEPTACLE_IGNITE, SoundCategory.BLOCKS, 0.7f, 0.7f, false);
                    return true;
                }
            } else {
                ((TileEntityReceptacle)tileEntity).setElement(null);
                ItemStack dust = new ItemStack(WizardryItems.spectral_dust, 1, currentElement.ordinal());
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, dust);
                } else if (!player.func_191521_c(dust)) {
                    player.func_71019_a(dust, false);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        Element element;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReceptacle && (element = ((TileEntityReceptacle)tileEntity).getElement()) != null) {
            EnumFacing facing = ((EnumFacing)state.func_177229_b((IProperty)field_176596_a)).func_176734_d();
            Vec3d centre = GeometryUtils.getCentre(pos);
            if (facing.func_176740_k().func_176722_c()) {
                centre = centre.func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a(0.1875)).func_72441_c(0.0, 0.125, 0.0);
            }
            int[] colours = PARTICLE_COLOURS.get((Object)element);
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(centre).scale(0.35f).time(48).clr(colours[0]).spawn(world);
            double r = 0.12;
            for (int i = 0; i < 3; ++i) {
                double x = r * (rand.nextDouble() * 2.0 - 1.0);
                double y = r * (rand.nextDouble() * 2.0 - 1.0);
                double z = r * (rand.nextDouble() * 2.0 - 1.0);
                ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(centre.field_72450_a + x, centre.field_72448_b + y, centre.field_72449_c + z).vel(x * -0.03, 0.02, z * -0.03).time(24 + rand.nextInt(8)).clr(colours[1]).fade(colours[2]).spawn(world);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos centre;
        if (placer instanceof EntityPlayer && world.func_180495_p(centre = pos.func_177972_a(((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_176596_a)).func_176734_d())).func_177230_c() == WizardryBlocks.imbuement_altar && Arrays.stream(EnumFacing.field_176754_o).allMatch(f -> world.func_180495_p(centre.func_177972_a(f)).func_177230_c() == WizardryBlocks.receptacle)) {
            WizardryAdvancementTriggers.restore_imbuement_altar.triggerFor((EntityPlayer)placer);
        }
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityReceptacle();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityReceptacle) {
            Element element = ((TileEntityReceptacle)tileEntity).getElement();
            return element == null ? 0 : element.ordinal() + 1;
        }
        return super.func_180641_l(state, world, pos);
    }

    static {
        EnumMap map = Maps.newEnumMap(Element.class);
        map.put(Element.MAGIC, new int[]{14993357, 0xFEFFBE, 10300659});
        map.put(Element.FIRE, new int[]{16750080, 16776807, 13641472});
        map.put(Element.ICE, new int[]{10742004, 15333884, 1278871});
        map.put(Element.LIGHTNING, new int[]{4234977, 0xF5F0FF, 2249844});
        map.put(Element.NECROMANCY, new int[]{11014606, 0xF575F5, 3679078});
        map.put(Element.EARTH, new int[]{11072520, 13172658, 7953448});
        map.put(Element.SORCERY, new int[]{5695715, 15269116, 1484365});
        map.put(Element.HEALING, new int[]{16774814, 0xFFFFF6, 10584576});
        PARTICLE_COLOURS = Maps.immutableEnumMap((Map)map);
    }
}

